package com.yizhi.application.rangeImport;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.library.application.feign.CaseLibraryClient;
import com.yizhi.library.application.vo.CaselibraryAuthorizeVO;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: dingxiaowei
 * @Date: 2019/12/3
 * @Description:案例活动可见范围异步导入
 */
public
@Component
class CaseLibraryImport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(CaseLibraryImport.class);

    @Autowired
    private AccountRangeClient accountRangeClient;

    @Autowired
    private CaseLibraryClient caseLibraryClient;
    @Autowired
    private RangeUtil importUtil;

    @Override
    protected String execute(Map<String, Object> map) {
        //从map中取值
        String ossUrl = (String) map.get("ossUrl");
        RequestContext res = (RequestContext) map.get("res");
        Long caseLibraryId = (Long) map.get("caseLibraryId");
        Long accountId = res.getAccountId();
        Long siteId = res.getSiteId();
        String accountFullName = res.getAccountFullName();
        Long companyId = res.getCompanyId();
        Date submitTime = new Date();
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);

        //将请求值装入param
        AccountRangeImportParam param = new AccountRangeImportParam();
        param.setType(AccountRangeImportParam.Type.CASELIBRARY);
        param.setOssUrl(ossUrl);
        param.setRequestContext(res);
        List<AccountRangeImportModel.SuccessAccount> successList = null;
        List<AccountRangeImportModel.ErrorAccount> errorList = null;
        List<Integer> integerList = null;
        //进行入库
        try {
            AccountRangeImportModel accountRangeImportModel = accountRangeClient.doImport(param);
            if (null != accountRangeImportModel) {
                successList = accountRangeImportModel.getSuccessList();
                errorList = accountRangeImportModel.getErrorList();
            }
            errorList = (errorList == null ? new ArrayList<>() : errorList);
            successList = (successList == null ? new ArrayList<>() : successList);

            List<CaselibraryAuthorizeVO> caseLibraryAuthorizes = new ArrayList<>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Timestamp createTime = Timestamp.valueOf(sdf.format(new Date()));

            if (!CollectionUtils.isEmpty(successList)) {
                for (AccountRangeImportModel.SuccessAccount rangeImportModel : successList) {
                    CaselibraryAuthorizeVO caseLibraryAuthorize = new CaselibraryAuthorizeVO();
                    caseLibraryAuthorize.setState(1);
                    caseLibraryAuthorize.setType(2);
                    caseLibraryAuthorize.setRelationId(rangeImportModel.getId());
                    caseLibraryAuthorize.setName(rangeImportModel.getName());
                    caseLibraryAuthorize.setCaseLibraryId(caseLibraryId);
                    caseLibraryAuthorize.setCreateById(accountId);
                    caseLibraryAuthorize.setCreateByName(accountFullName);
                    caseLibraryAuthorize.setCreateTime(createTime);
                    caseLibraryAuthorizes.add(caseLibraryAuthorize);
                }
                caseLibraryClient.insertAuthorizes(caseLibraryAuthorizes);
            }

            importUtil.returnResults(taskContext, successList, errorList, ossUrl);
        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, "案例活动可见范围异步导入过程中出现错误");
            LOGGER.error("案例活动可见范围异步导入过程中出现错误", e);
        }

        return "ok";
    }


}
