package com.yizhi.application.util;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Date 2020/9/17 3:21 下午
 * @Author lvjianhui
 **/
public class WmyDateUtils {

    /**
     *
     * @param durationStr
     * @return h:mm:ss
     */
    static public String durationFormart(String durationStr) {

        if(StringUtils.isEmpty(durationStr) || "null" == durationStr) {
            return "0";
        }
        Long duration = Long.valueOf(durationStr);
        if (duration <= 0) {
            return "0";
        }

        Long hour = duration / 3600;
        Long minute = (duration % 3600) / 60;
        Long seconds = duration % 60;

        StringBuffer sbTime = new StringBuffer();
        if (hour < 10) {
            sbTime = sbTime.append("0").append(hour);
        }else {
            sbTime = sbTime.append(hour);
        }
        sbTime = sbTime.append(":");

        if (minute < 10) {
            sbTime = sbTime.append("0").append(minute);
        }else {
            sbTime = sbTime.append(minute);
        }
        sbTime = sbTime.append(":");

        if (seconds < 10) {
            sbTime = sbTime.append("0").append(seconds);
        }else {
            sbTime = sbTime.append(seconds);
        }

        return  sbTime.toString();
    }

    static public Date stringToDate(String date, String dateFormart) {
        String df = "yyyy/MM/dd";
        if (date.contains("-")) {
            df = "yyyy-MM-dd";
        }
        if (StringUtils.isNotEmpty(dateFormart)) {
            df = dateFormart;
        }

        SimpleDateFormat sdf = new SimpleDateFormat(df);
        try {
            return sdf.parse(date);
        } catch (Exception e) {
            e.getStackTrace();
        }
        return null;
    }

    static public Date stringToDate(String date) {

        String df = "yyyy/MM/dd";
        if (date.contains("-")) {
            df = "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(df);
        try {
            return sdf.parse(date);
        } catch (Exception e) {
            e.getStackTrace();
        }
        return null;
    }

}
