package com.yizhi.application.wechat;

import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.wechat.application.feign.PublicConfigClient;
import com.yizhi.wechat.application.vo.wechat.Wparam;
import com.yizhi.wechat.application.vo.wechat.domain.PublicPlatformConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * @author lilingye
 * @date 日期
 */
@Api(tags = "微信配置信息")
@RestController
@RequestMapping("/manage/publicConfig")
@Log4j2
public class PublicConfigController {
    @Autowired
    PublicConfigClient publicConfigClient;
    @ApiOperation(value = "新增配置信息", notes = "新增配置信息",response = PublicPlatformConfigVo.class)
    @PostMapping(value = "/insert")
    public Response<PublicPlatformConfigVo> insert(@ApiParam(value = "配置信息实体") @RequestBody PublicPlatformConfigVo publicPlatformConfig){
        PublicPlatformConfigVo publicConfig = new PublicPlatformConfigVo();
        if (StringUtils.isNotBlank(publicPlatformConfig.getAgentId())){

            publicConfig.setAgentId(publicPlatformConfig.getAgentId());
            publicConfig.setAppId(publicPlatformConfig.getAppId());
            publicConfig.setSecret(publicPlatformConfig.getSecret());
            publicConfig.setName(publicPlatformConfig.getName());

        } else {
            publicConfig.setAgentId(publicPlatformConfig.getAgentId());
            publicConfig.setAppId(publicPlatformConfig.getAppId());
            publicConfig.setName(publicPlatformConfig.getName());
        }
        if (publicConfigClient.findPublicPlatformConfig(publicConfig)!=null) {
            return Response.fail(InternationalEnums.PUBLICCONFIGCONTROLLER.getCode());
        }
        PublicPlatformConfigVo conf =null;
        try {
             conf= publicConfigClient.insertPublicPlatformConfigInfo(publicPlatformConfig);

        } catch (Exception e) {
            log.info("~~"+e.getLocalizedMessage());
        }
        if (conf!=null){
            return Response.ok(conf);
        } else {
            return  Response.fail(ReturnCode.SAVE_FAIL.getCode(),ReturnCode.SAVE_FAIL.getMsg());
        }
    }

    /**
     * 修改
     */
    @ApiOperation(value = "修改配置信息", notes = "修改配置信息",response = PublicPlatformConfigVo.class)
    @PostMapping(value = "/update")
    public Response<PublicPlatformConfigVo> update(@ApiParam(value = "配置信息实体") @RequestBody PublicPlatformConfigVo publicPlatformConfig){

        PublicPlatformConfigVo conf =null;
//        RequestContext context = ContextHolder.get();
//        publicPlatformConfig.setSiteCode(context.getSiteCode());
//        publicPlatformConfig.setCompanyCode(context.getCompanyCode());
        try {
            conf= publicConfigClient.updatePublicPlatformConfigInfo(publicPlatformConfig);

        } catch (Exception e) {
            log.info("~~"+e.getLocalizedMessage());
        }
        if (conf!=null){
            return Response.ok(conf);
        } else {
            return Response.fail(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    /**
     * 查看
     * @param id
     * @return
     */
    @ApiOperation(value = "查询配置信息", notes = "查询配置信息",response = PublicPlatformConfigVo.class)
    @GetMapping(value = "/get")
    public Response<PublicPlatformConfigVo> get(@ApiParam(name = "id", value = "配置id", required = true)
                                                  @RequestParam(value = "id",required = true) Long id){

        PublicPlatformConfigVo conf =null;
        try {
            conf= publicConfigClient.getPublicPlatformConfigInfo(id);

        } catch (Exception e) {
            log.info("~~"+e.getLocalizedMessage());
        }
        if (conf!=null){
            return Response.ok(conf);
        } else {
            return Response.fail(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());
        }
    }

    /**
     * 查询列表
     * @param pageNo
     * @param pageSize
     * @return
     */
    @ApiOperation(value = "查询配置里列表", notes = "查询配置里列表",response = PublicPlatformConfigVo.class)
    @GetMapping(value = "/list")
    public Response<PublicPlatformConfigVo> get(@ApiParam(name = "pageNo", value = "当前页数", required = true) @RequestParam(value = "pageNo",required = true,defaultValue = "1") Integer pageNo,
                                              @ApiParam(name = "pageSize", value = "每页条数", required = true)  @RequestParam(value = "pageSize",required = true,defaultValue = "10") Integer pageSize,
                                              @ApiParam(name = "name", value = "模糊查询字段", required = false)  @RequestParam(value = "name",required = false) String name
    ){
        return Response.ok(publicConfigClient.getPublicPlatformConfigs(pageNo,pageSize,name));
    }

    /**
     * 删除
     * @param wparam 配置ids
     * @return
     */
    @ApiOperation(value = "删除配置信息", notes = "删除配置信息")
    @PostMapping(value = "/delete")
    public Response<String> delete(@ApiParam(value = "删除列表的idList") @RequestBody Wparam wparam){
        boolean f = publicConfigClient.deletePublicPlatformConfig(wparam.getIds());
        if (f) {
            return Response.ok();
        } else {
            return Response.ok(ReturnCode.DELETE_FAIL);
        }
    }
}
