package com.yizhi.application.caseLibrary.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 上传文件转换为图片  进行逻辑判断  完成
 *
 * @author wangfeida
 */
@Component
public class StuUpConvert {

    private final Logger logger = LoggerFactory.getLogger(StuUpConvert.class);

    @Autowired
    private StuCommonUtils stuCommonUtils;


    /** 测试函数
     * inputFilePathName  网络流的url
     * fileName           生成的文件名字
     * outputFilePath     输出路径
     * dpi                分辨率  值越大分辨率越高 转换效率也越长
     * flag               0
     * openOffice         插件所在的路径
     *
     * @param args
     * @throws IOException
     */
//	public static void main(String[] args) throws IOException {
//		String url="http://fulan-test.oss-cn-hangzhou.aliyuncs.com/%E6%B5%8B%E8%AF%95%E7%8E%AF%E5%A2%83%E5%8F%91%E5%B8%832018.02.28.docx";
////		String url2="http://fulan-test.oss-cn-hangzhou.aliyuncs.com/%E7%AE%80%E5%8E%86.pdf";
//		String outputFilePath=UtilConstants.DOC_PATH;
//		int dpi=1000;
//		int flag=0;
//		String fileName = "简历.docx";
////		String fileName2 = "注册.pdf";
//		String openOffice= UtilConstants.OPENOFFICE_PATH;
//		UpConvert upConvert=new UpConvert();
//		String x=upConvert.convert(url,fileName,outputFilePath, dpi,flag,openOffice);
//		System.out.println(x);
//	}


    /**
     * inputFilePathName  网络流的url
     * fileName           生成的文件名字
     * outputFilePath     输出路径
     * dpi                分辨率  值越大分辨率越高 转换效率也越长
     * flag               0
     * openOffice         插件所在的路径
     *
     * @throws IOException
     */
    //inputFilePathName  流名字
    public String convert(String url, String fileName, String outputFilePath, int dpi, int flag, String getofficeHome) throws IOException {
        OfficeToPdf otp = new OfficeToPdf();
        String filePath = stuCommonUtils.downLoadFromUrl(url, fileName, outputFilePath);             //网络流地址   需要保存的文件名字    保存的路径      filePath是文件的下载地址
        //判断是否是指定的几种类型
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (isAppoint(suffix)) {
            //创建文件夹
            File file1 = new File(filePath);
            int dot = file1.getName().lastIndexOf('.');
            String imagePDFName = file1.getName().substring(0, dot);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");//设置日期格式
            outputFilePath = outputFilePath + File.separator + imagePDFName + df.format(new Date()); //此目录下创建一个以传入文件名字的文件夹
            if (suffix.equals("pdf")) {  //如果后缀是pdf直接进行转换
                String result = stuCommonUtils.pdfToPng(filePath, outputFilePath, dpi, flag);
                file1.delete();
                return result;
            } else {                                                                     //如果是指定格式的其他类型 先转换为pdf
                File file = otp.openOfficeToPDF(filePath, outputFilePath, getofficeHome);  //office转pdf  //下载的文件的确切地址   输出文件路径    插件地址
                File file2 = new File(filePath);
                file2.delete();
                String pdfPath = file.getParent() + File.separator + file.getName();                     //pdf路径
                String result = stuCommonUtils.pdfToPng(pdfPath, file.getParent(), dpi, flag);        //pdf转png
                file.delete();
                return result;
            }
        } else {
            return "不是指定的格式";
        }
    }


    /**
     * 判断文件类型是否是指定的文件类型
     */
    public boolean isAppoint(String fileName) {
        if (fileName.equals("pdf") || fileName.equals("ppt") || fileName.equals("pptx") || fileName.equals("doc")
                || fileName.equals("docx") || fileName.equals("xls") || fileName.equals("xlsx")
                || fileName.equals("csv")) {
            return true;
        } else {
            logger.error("文件格式错误");
            return false;
        }
    }
}
