package com.yizhi.application.course.controller;



import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CommentClient;
import com.yizhi.course.application.vo.ThumbsUpVO;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags="学员端-课程点赞api",description="学员端-课程点赞接口")
@RestController
@RequestMapping("/api/thumbsUp")
public class ThumbsUpController {
private static final Logger logger=LoggerFactory.getLogger(ThumbsUpController.class);
	

@Autowired
private CommentClient commentClient;

	@ApiOperation(value="根据前端传入的点赞对象新增点赞(新增)")
	@PostMapping("/save")
	public Response<String> saveThumbsUp(
			@RequestBody ThumbsUpVO thumbsUp
//			@ApiParam(name="comment_id",value="需要点赞的评论id") @RequestParam(name="comment_id") Long commentId,
//			@ApiParam(name="course_id",value="课程id") @RequestParam(name="course_id") Long courseId
			){
		
		RequestContext context = ContextHolder.get();
		thumbsUp.setAccountId(context.getAccountId());
		thumbsUp.setSiteId(context.getSiteId());
		thumbsUp.setCompanyId(context.getCompanyId());


		try {
			if(commentClient.saveThumbsUp(thumbsUp)!=null){
				return Response.ok();
			}
			return Response.fail();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.error("",e);
			return Response.fail();
		}
	}
	
	@ApiOperation(value="根据点赞id修改点赞状态并且点赞数减1")
	@PostMapping("/delete")
	public Response<String> deleteThumbsUp(
			@RequestBody ThumbsUpVO thumbsUp
//			@ApiParam(name="comment_id",value="需要点赞的评论id") @RequestParam(name="comment_id") Long commentId,
//			@ApiParam(name="course_id",value="课程id") @RequestParam(name="course_id") Long courseId
					){
		
		
		try {
			thumbsUp.setAccountId(ContextHolder.get().getAccountId());
			if(commentClient.deleteThumbsUp(thumbsUp)!=null){
				return Response.ok();
			}
			return Response.fail();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			logger.error("",e);
			return Response.fail();
		}
	}

	/**
	 * Pc端课程点赞
	 * @param thumbsUp
	 * @return
	 */
	@PostMapping("/pc/save")
	@ApiOperation(value = "Pc端课程点赞",response =ThumbsUpVO.class )
	Response pcSaveThumbsUp(@ApiParam(value ="courseId 、commentId-评论ID" )@RequestBody ThumbsUpVO thumbsUp){

		RequestContext context = ContextHolder.get();
		thumbsUp.setAccountId(context.getAccountId());
		thumbsUp.setSiteId(context.getSiteId());
		thumbsUp.setCompanyId(context.getCompanyId());
		Boolean flag = commentClient.saveThumbsUp(thumbsUp);
		if (flag){
			thumbsUp.setHasThumbsUp(true);
			return Response.ok(thumbsUp);
		}
		return Response.fail(Constants.MSG_COMMENT_THUMBSUP_FAIL.getCode().toString(),
				Constants.MSG_COMMENT_THUMBSUP_FAIL.getName());
	}

	/**
	 * PC端课程取消点赞
	 * @return
	 */
	@PostMapping("/pc/delete")
	@ApiOperation(value="根据点赞id修改点赞状态并且点赞数减1",response =ThumbsUpVO.class)
	Response pcDeleteThumbsUp(@ApiParam(value ="courseId 、commentId-评论ID" )@RequestBody ThumbsUpVO thumbsUp){
		RequestContext context = ContextHolder.get();
		thumbsUp.setAccountId(context.getAccountId());
		thumbsUp.setSiteId(context.getSiteId());
		thumbsUp.setCompanyId(context.getCompanyId());

		Boolean flag = commentClient.deleteThumbsUp(thumbsUp);
		if (flag){
			thumbsUp.setHasThumbsUp(false);
			return Response.ok(thumbsUp);
		}
		return Response.fail(Constants.MSG_CANCEL_THUMBSUP_FAIL.getCode().toString(),
				Constants.MSG_CANCEL_THUMBSUP_FAIL.getName());
	}
	
	
}
