package com.yizhi.application.lecturer;


import com.yizhi.lecturer.application.feign.LecturerClassificationClient;
import com.yizhi.lecturer.application.vo.CommonTree;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import lombok.extern.log4j.Log4j2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @description: 讲师库分类
 * @author: lly
 * @date: 2019-04-18 11:50
 **/
@Log4j2
@Api(tags = "讲师库分类")
@RestController
@RequestMapping("/lecturer/api/classification")
public class LecturerClassificationController {
    private static final Logger LOG = LoggerFactory.getLogger(LecturerClassificationController.class);

    @Autowired
    private LecturerClassificationClient classificationClient;

    /**
     * 分类列表
     *
     * @param type
     * @return
     */
    @GetMapping(value = "/list")
    public Response<String> getClassificationList(@RequestParam(name = "type", required = false, defaultValue = "1") Integer type) {
        List<CommonTree> classificationList = classificationClient.getClassificationList(type);
        LOG.info("返回列表{}",classificationList);
        return Response.ok(classificationList);
    }

}