package com.yizhi.application.course.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.application.tools.PageTools;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.ClassifyGroupInfoClient;
import com.yizhi.course.application.vo.ClassifyGroupInfoVO;
import com.yizhi.course.application.vo.domain.ClassifyGroupInfoEntityVo;
import com.yizhi.site.application.feign.PortalManageFeignClients;
import com.yizhi.site.application.vo.domain.PortalNavigateVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Objects;

@RestController
@RequestMapping("/manage/classify/group/info")
@Api(tags = "管理端-课程分类组基本信息（除关联分类id）", description = "课程分类组基本信息")
public class ClassifyGroupInfoController {

    @Autowired
    private ClassifyGroupInfoClient classifyGroupInfoClient;

    @Autowired
    private PortalManageFeignClients portalManageFeignClients;

    @PostMapping("/save")
    @ApiOperation(value = "保存有id（更新没有id）", response = ClassifyGroupInfoEntityVo.class)
    public Response<ClassifyGroupInfoEntityVo> save(@RequestBody ClassifyGroupInfoEntityVo classifyGroupInfo){
        ClassifyGroupInfoEntityVo addStatus = classifyGroupInfoClient.save(classifyGroupInfo);
        if(Objects.isNull(addStatus)){
            return  Response.fail(InternationalEnums.CLASSIFYGROUPINFOCONTROLLER1.getCode());
        }
        return  Response.ok(addStatus);
    }

    @GetMapping("/list")
    @ApiOperation(value = "获取分类组的列表信息（可增加状态【status】条件指定", response = ClassifyGroupInfoEntityVo.class)
    public Response<ClassifyGroupInfoEntityVo> List(
                                        @ApiParam(name = "pageNo", value = "分页的页码", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                        @ApiParam(name = "pageSize", value = "分页每页的条数", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize,
                                        @ApiParam(name = "status", value = "状态 -1草稿，0 下架，1上架（可选参数）") @RequestParam(name="status", required = false ) Integer status){
        Page<ClassifyGroupInfoEntityVo> data = classifyGroupInfoClient.list(pageNo, pageSize, status);

        return Response.ok(PageTools.convertPage(data));
    }

    @GetMapping("/list/all")
    @ApiOperation(value = "获取当前用户访问站点下的全部分类组基本信息(例如提供给首页配置分类组的关联选择使用)", response = ClassifyGroupInfoEntityVo.class)
    public Response<ClassifyGroupInfoEntityVo> listAll(){
        // 上下文下信息
        RequestContext rc = ContextHolder.get();
        return Response.ok(classifyGroupInfoClient.listAll(rc.getCompanyId(),rc.getSiteId()));
    }

    @GetMapping("/get")
    @ApiOperation(value = "根据课程分类组的id获取分类组的基本信息", response = ClassifyGroupInfoEntityVo.class)
    public Response<ClassifyGroupInfoEntityVo> get(
                                        @ApiParam(name = "id", value = "要查看的分类组的id", required = true) @RequestParam(name = "id") Long id){
        return Response.ok(classifyGroupInfoClient.get(id));
    }

    @GetMapping("/delete")
    public Response<Boolean> delete(
                                @ApiParam(name = "id", value = "要删除的分类组的id", required = true) @RequestParam(name = "id") Long id){
        RequestContext rc = ContextHolder.get();

        List<PortalNavigateVo> data = portalManageFeignClients.getNavigateListByRelationId(rc.getSiteId(),id);
        if(CollectionUtils.isEmpty(data)){
            return Response.ok(classifyGroupInfoClient.delete(id));
        }else {
            return Response.fail(InternationalEnums.CLASSIFYGROUPINFOCONTROLLER2.getCode());
        }
    }

}
