package com.yizhi.application.point.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.point.application.feign.PointProductFeignClients;
import com.yizhi.point.application.vo.PointSearchParamVO;
import com.yizhi.point.application.vo.PointUserPageListVO;
import com.yizhi.point.application.vo.domain.PointProductVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 我的积分
 * @author mei
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "积分商品管理 管理端")
@RestController
@RequestMapping("/manage/point/product")
public class PointProductController {
	
	private static final Logger LOG = LoggerFactory.getLogger(PointProductController.class);
	
	@Autowired
	PointProductFeignClients pointProductFeignClients;
	
	@ApiOperation(value = "积分商品新增", notes = "积分商品新增")
	@PostMapping("/insert")
	public Response<Long> insertDetail(@RequestBody PointProductVo pointProductVo){
		if(null == pointProductVo){
			return Response.fail();
		}

		RequestContext requestContext = ContextHolder.get();
		if (null == requestContext) {
			Response.fail();
		}
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		Date date = new Date();

		pointProductVo.setCreateById(accountId);
		pointProductVo.setCreateByName(accountName);
		pointProductVo.setCreateTime(date);
		pointProductVo.setUpdateById(accountId);
		pointProductVo.setUpdateByName(accountName);
		pointProductVo.setUpdateTime(date);
		
		return Response.ok(pointProductFeignClients.insertDetail(pointProductVo));
	}

	@ApiOperation(value = "积分商品删除")
	@PostMapping("/delete")
	public Response<Long> deleteDetailById(@RequestBody PointProductVo pointProductVo) {
		if (null == pointProductVo) {
			return Response.fail();
		}
		long i = pointProductFeignClients.deleteDetailById(pointProductVo);

		if (i == -1L) {
			Response.fail(InternationalEnums.POINTACTIVITYCONTROLLER.getCode());

		}
		return Response.ok();
	}

	@ApiOperation(value = "积分商品修改", notes = "积分商品修改")
	@PostMapping("/update")
	public Response<Long> updateById(@RequestBody PointProductVo pointProductVo){
		if(null == pointProductVo){
			return Response.fail();
		}

		RequestContext requestContext = ContextHolder.get();
		if (null == requestContext) {
			Response.fail();
		}
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		Date date = new Date();
		pointProductVo.setUpdateById(accountId);
		pointProductVo.setUpdateByName(accountName);
		pointProductVo.setUpdateTime(date);
		return Response.ok(pointProductFeignClients.updateById(pointProductVo));
	}
	
	@ApiOperation(value = "积分商品启用", notes = "积分商品启用")
	@PostMapping("/enabled")
	Response<Boolean> bannerUp(@RequestBody PointProductVo pointProductVo){
		if(null == pointProductVo){
			return Response.fail();
		}

		RequestContext requestContext = ContextHolder.get();
		if (null == requestContext) {
			Response.fail();
		}
 
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		pointProductVo.setUpdateById(accountId);
		pointProductVo.setUpdateByName(accountName);
		
		return Response.ok(pointProductFeignClients.pointUp(pointProductVo));
	}
	
	@ApiOperation(value = "积分商品停用", notes = "积分商品停用")
	@PostMapping("/disabled")
	Response<Boolean> bannerDown(@RequestBody PointProductVo pointProductVo){
		if(null == pointProductVo){
			return Response.fail();
		}
		
		RequestContext requestContext = ContextHolder.get();
		if (null == requestContext) {
			Response.fail();
		}
 
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		pointProductVo.setUpdateById(accountId);
		pointProductVo.setUpdateByName(accountName);
		
		return Response.ok(pointProductFeignClients.pointDown(pointProductVo));
	}
	
	@ApiOperation(value = "积分商品、分页列表", notes = "积分商品、分页列表", response = PointProductVo.class)
	@PostMapping("/list")
	public Response<Page<PointProductVo>> productList(@RequestBody PointSearchParamVO searchParamVO){
		try {
			return Response.ok(pointProductFeignClients.productList(searchParamVO));
		} catch (Exception e) {
			LOG.error("服务出错。", e);
			return Response.fail();
		}
	}
}