package com.yizhi.application.project.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.training.application.feign.TpCommentClient;
import com.yizhi.training.application.vo.domain.TpCommentVo;
import com.yizhi.training.application.vo.manage.PageCommentVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
/**
 * <p>
 * 培训项目 - 评论 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-27
 */
@Api(tags = "项目评论接口")
@RestController
@RequestMapping("/manage/tpComment")
public class TpCommentController {

    @Autowired
    TpCommentClient tpCommentClient;

    private static final Logger LOGGER = LoggerFactory.getLogger(TpCommentController.class);


    @GetMapping("/list")
    @ApiOperation(value = "评论列表查询", notes = "返回评论列表", response = PageCommentVo.class)
    public Response<Page<PageCommentVo>> list(
            @ApiParam(value = "培训项目id",required = true)@RequestParam("trainingProjectId")Long trainingProjectId,
            @ApiParam(value = "关联业务类型:1活动服务;2新闻资讯；3培训测试；4培训资讯") @RequestParam(name = "bizType", defaultValue = "1") Integer bizType,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页", required = true) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条", required = true) @RequestParam(name = "pageSize", defaultValue = "20") Integer pageSize){
        RequestContext requestContext = ContextHolder.get();
        Page<PageCommentVo> page = tpCommentClient.list(trainingProjectId, bizType, requestContext.getAccountId(),pageNo,pageSize,0);
        return Response.ok(page);
    }

    @PostMapping("/deleteTpComment")
    @ApiOperation(value = "评论删除", notes = "返回操作状态")
    public Response delete(
            @RequestBody TpCommentVo tpComment
//            @ApiParam(value = "评论id",required = true)@RequestParam("tpCommentId")Long tpCommentId,
//            @ApiParam(value = "下架意见")@RequestParam(name = "auditContent",required = false)String auditContent
    ){
        RequestContext requestContext = ContextHolder.get();
        tpComment.setAuditorId(requestContext.getAccountId());
        Boolean f = tpCommentClient.delete(tpComment);
        if (f) {
            LOGGER.info("评论删除操作成功");
            return Response.ok("评论删除操作成功");
        } else {
            LOGGER.error("评论删除操作失败");
            return Response.fail(InternationalEnums.TPCOMMENTCONTROLLER1.getCode());
        }

    }

    @GetMapping("/up")
    @ApiOperation(value = "评论上架", notes = "返回操作状态")
    public Response up(@RequestParam("id")Long id) {
    	Boolean up = tpCommentClient.up(id);
        if (up) {
            LOGGER.info("评论上架操作成功");
            return Response.ok("评论上架操作成功");
        } else {
            LOGGER.error("评论上架操作失败");
            return Response.fail(InternationalEnums.TPCOMMENTCONTROLLER2.getCode());
        } 	
    }

    @GetMapping("/down")
    @ApiOperation(value = "评论下架", notes = "返回操作状态")
    public Response down(@RequestParam("id")Long id) {
    	Boolean down = tpCommentClient.down(id);
        if (down) {
            LOGGER.info("评论下架操作成功");
            return Response.ok("评论下架操作成功");
        } else {
            LOGGER.error("评论下架操作失败");
            return Response.fail(InternationalEnums.TPCOMMENTCONTROLLER3.getCode());
        } 	
    }
    
	@ApiOperation(value = "评论信息导出")
	@GetMapping("/list/export")
	public Response<String> export(
			@ApiParam(name = "trainingProjectId", value = "项目id") @RequestParam(name = "trainingProjectId") Long trainingProjectId,
			@ApiParam(name = "trainingProjectName", value = "项目名称") @RequestParam(name = "trainingProjectName") String trainingProjectName) {
		return Response.ok(tpCommentClient.export(trainingProjectId, trainingProjectName));
	}
}

