package com.yizhi.application.forum.controller;



import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.forum.application.feign.student.StudentPostsClassifyClient;
import com.yizhi.forum.application.vo.domain.PostsClassifyVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "学员端-帖子分类接口")
@RestController
@RequestMapping("/student/postsClassify/")
public class StudentPostsClassifyController {

    private static final Logger LOG = LoggerFactory.getLogger(StudentPostsClassifyController.class);
    @Autowired
    private StudentPostsClassifyClient studentPostsClassifyClient;

    @ApiOperation(value = "获取学员端分类分页数据", response = PostsClassifyVo.class)
    @GetMapping("/getPageToStudent")
    public Response<Page<PostsClassifyVo>> getPageToStudent(@ApiParam("分类名称") @RequestParam(value = "name", required = false) String name,
                                                            @ApiParam("是否对可见范围作判断") @RequestParam(value = "canSend", defaultValue = "false") Boolean canSend,
                                                            @ApiParam("默认第一页") @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
                                                            @ApiParam("默认10条") @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {

        return Response.ok(studentPostsClassifyClient.getPageToStudent(name, canSend, pageNo, pageSize));
    }

    @ApiOperation(value = "获取学员端分类数据", response = PostsClassifyVo.class)
    @GetMapping("/getList")
    public Response<Object> getList(@ApiParam("分类名称") @RequestParam(value = "name", required = false) String name,
                                    @ApiParam("是否对可见范围作判断") @RequestParam(value = "canSend", defaultValue = "false") Boolean canSend) {
        Page<PostsClassifyVo> pageToStudent = studentPostsClassifyClient.getPageToStudent(name, canSend, 1, Integer.MAX_VALUE);
        return Response.ok(pageToStudent.getRecords());
    }
}
