package com.yizhi.application.protal.controller;

import com.yizhi.course.application.vo.CourseTotalDurationInfoVO;
import com.yizhi.site.application.enums.FunctionTypeCode;
import com.yizhi.site.application.feign.api.FunctionDisplayConfigApiClients;
import com.yizhi.site.application.vo.domain.FunctionDisplayConfigVo;
import com.yizhi.site.application.vo.site.FunctionDisplayConfigVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 18:07 2019/4/29
 * @Modified By
 */
@Api(tags = "学员端-显示配置", description = "功能项显示")
@RestController
@RequestMapping("/api/functionDisplay/config")
public class FunctionDisplayConfigController {

    @Autowired
    private FunctionDisplayConfigApiClients configApiClients;


    @GetMapping("/get")
    @ApiOperation(value = "获取显示配置",response = FunctionDisplayConfigVO.class)
    public Response<CourseTotalDurationInfoVO> getBySiteId(){
        //RequestContext rt = ContextHolder.get();
        List<FunctionDisplayConfigVo> dataFunction = configApiClients.getAllBySiteId();
        CourseTotalDurationInfoVO ctdi = new CourseTotalDurationInfoVO();
        ctdi.setTrainingDurationShow(false);
        ctdi.setCourseDurationShow(false);
        if(!CollectionUtils.isEmpty(dataFunction)){
            for(FunctionDisplayConfigVo item : dataFunction){
                if(FunctionTypeCode.COURSE.getCode().equals(item.getFunctionType())){
                    ctdi.setCourseDurationShow(item.getShowDisplay());
                }else if(FunctionTypeCode.TRAINING.getCode().equals(item.getFunctionType())){
                    ctdi.setTrainingDurationShow(item.getShowDisplay());
                }
            }
        }
        return Response.ok(ctdi);
    }


}
