package com.yizhi.application;

import org.apache.commons.lang.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 时间转换类
 *
 * @Author: shengchenglong
 * @Date: 2018/3/6 14:30
 */
@Component
public class DateConvert implements Converter<String, Date> {

    @Override
    public Date convert(String stringDate) {
        if (StringUtils.isBlank(stringDate)){
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {

            return simpleDateFormat.parse(stringDate);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return null;
    }

}