package com.yizhi.application.course.util;

import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.course.application.feign.CourseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 素材转移
 * @author ly
 */
@Component
public class MaterialTransferService extends AbstractDefaultTask<String, Map<String,Object>> {
	
	private static final Logger LOGGER = LoggerFactory.getLogger(MaterialTransferService.class);
	


	@Autowired
    CourseClient courseClient;

	
	

	@Override
	protected String execute(Map<String, Object> map) {
        List<String> codeList = (ArrayList<String>)map.get("codeList");
        Long afterSiteId = Long.valueOf(String.valueOf(map.get("afterSiteId")));
        Long beforeSiteId = Long.valueOf(String.valueOf(map.get("beforeSiteId")));
        Long companyId = Long.valueOf(String.valueOf(map.get("companyId")));

        LOGGER.info("codeList："+codeList);
        LOGGER.info("afterSiteId："+afterSiteId+";beforeSiteId："+beforeSiteId+";companyId："+companyId);


        courseClient.updateMaterialData(codeList,afterSiteId,beforeSiteId,companyId);

        return null;
		 
	}

}
