package com.yizhi.application.course.util;

import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.springframework.util.StringUtils;

import java.io.File;

public class OfficeToPdf {
	
	 /**
     * 使Office2003-2007全部格式的文档(.doc|.docx|.xls|.xlsx|.ppt|.pptx) 转化为pdf文件
     * @param inputFilePath 源文件路径,如："C:/Users/phone/Desktop/新建文件夹 (3)/22.docx"
     * @return
     */
    public   File openOfficeToPDF(String filePath,String outputFilePath,String getofficeHome) {
        return office2pdf(filePath,outputFilePath,getofficeHome);
    }



    /**
     * 根据插件安装路径连接OpenOffice.org 并且启动OpenOffice.org  启动插件
     * officeHome的路径 E:\\pdf\\office\\OpenOfficePortable\\App\\openoffice
     * @return
     */
    public  OfficeManager getOfficeManager(String getofficeHome) {
        DefaultOfficeManagerConfiguration config = new DefaultOfficeManagerConfiguration();
         // 设置OpenOffice.org 4的安装目录
        config.setOfficeHome(getofficeHome);
        // 启动OpenOffice的服务
        OfficeManager officeManager = config.buildOfficeManager();
        officeManager.start();
        return officeManager;
    }

    /**
     * 转换文件
     * @param inputFile           E:\png\简历.docx
     * @param outputFilePath      E:\png
     * @param filePath            E:\png\简历.docx
     * @param converter
     */
    public   File converterFile(File inputFile,String outputFilePath,String filePath,OfficeDocumentConverter converter) {
        String outputFileName=inputFile.getName();                                   //输出文件名字的确切路径
        String name=outputFileName.substring(0, outputFileName.lastIndexOf("."));    //输出文件名字
        File outputFile = new File(outputFilePath+"\\"+name+".pdf");
        converter.convert(inputFile, outputFile);//转换
        return outputFile;
    }

    /**
     * 使Office2003-2007全部格式的文档(.doc|.docx|.xls|.xlsx|.ppt|.pptx) 转化为pdf文件
     * @param inputFilePath 源文件路径，如："D:/论坛.docx"
     * @param outputFilePath 目标文件路径，如："D:/论坛.pdf"
     * @return
     */
    public   File office2pdf(String filePath,String outputFilePath,String officeHome) {
        OfficeManager officeManager = null;
        try {
            if (StringUtils.isEmpty(filePath)) {
                return null;
            }
            File inputFile = new File(filePath);   //需要转换的文件
            //转换后的文件路径
            String fileName=inputFile.getName();   //转换前的文件名字
            if (!inputFile.exists()) {
                return null;
            }
            //获取OpenOffice的安装路劲
            officeManager = getOfficeManager(officeHome);
            //连接OpenOffice
            OfficeDocumentConverter converter=new OfficeDocumentConverter(officeManager);
            //转换并返回转换后的文件对象
            return converterFile(inputFile,outputFilePath,filePath,converter);  //还输出到本目录下   docx路径     输出路径    
        } catch (Exception e) {
            System.out.println("转化出错!");
            e.printStackTrace();
        } finally {
            if (officeManager != null) {
                //停止openOffice
                officeManager.stop(); 
            }
        }
        return null;
    }


    /**
     * 获取inputFilePath的后缀名,如:"C:/Users/phone/Desktop/新建文件夹 (3)/22.docx" 
     * @param inputFilePath
     * @return
     */
    public String getPostfix(String inputFilePath) {
        return inputFilePath.substring(inputFilePath.lastIndexOf(".") + 1);
    }
}
