package com.yizhi.application.course.util;

import com.alibaba.fastjson.JSON;

import com.yizhi.util.application.pdf.Pdf2Png;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

/**
 * 转多页  完成
 * @author wangfeida
 *
 */
public class PdfToPng {
	
	private  final static Logger logger = LoggerFactory.getLogger(PdfToPng.class);

    /***
     * PDF文件转PNG图片  
     * @param pdfPath        E:\png\简历.pdf
     * @param outputFilePath 图片存放的文件夹    E:\png
     * @param dpi dpi越大转换后越清晰，相对转换速度越慢  
     * @param flag 页数 为0则转换全部页数 
     * @return
     * @throws IOException
     */
    @Deprecated
    public static String pdfToPng3(String pdfPath, String outputFilePath, int dpi, int flag) throws IOException {
        File file = new File(pdfPath);
        PDDocument pdDocument = null;
        try {
            if (createDirectory(outputFilePath)) {
                pdDocument = PDDocument.load(file);
                PDFRenderer renderer = new PDFRenderer(pdDocument);
                int pages = pdDocument.getNumberOfPages();
                if (flag > 0) {//大于0则打印具体页数
                    if (flag < pages) {
                        pages = flag;
                    }
                }
                StringBuffer imgFilePath = null;
                for (int i = 0; i < pages; i++) {
                    String imgFilePathPrefix = outputFilePath + File.separator;
                    imgFilePath = new StringBuffer();
                    imgFilePath.append(imgFilePathPrefix);
                    imgFilePath.append(String.valueOf(i + 1));
                    imgFilePath.append(".png");
                    File dstFile = new File(imgFilePath.toString());
                    BufferedImage image = renderer.renderImageWithDPI(i, dpi);
                    ImageIO.write(image, "png", dstFile);
                    logger.info("解析 {} pdf, total:{}, current:{}", pdfPath, pages, i);
                }
                System.out.println(outputFilePath + "1111");
                return outputFilePath;

            } else {
                return "创建文件夹错误";
            }
        } catch (Exception e) {
            logger.info("Pdf转Png发生错误{}", JSON.toJSONString(e));
            return "Pdf转Png转换发生错误";
        } finally {
            pdDocument.close();
        }

    }

    public static String pdfToPng2(String pdfPath, String outputFilePath, int dpi, int flag){
        if (createDirectory(outputFilePath)) {
            logger.info("Pdf转Png处理开始");
            try (final PDDocument document = PDDocument.load(new File(pdfPath))){
                PDFRenderer pdfRenderer = new PDFRenderer(document);
                for (int page = 0; page < document.getNumberOfPages(); ++page)
                {
                    BufferedImage bim = pdfRenderer.renderImageWithDPI(page, dpi, ImageType.RGB);
                    String fileName = outputFilePath + File.separator + (page+1) + ".png";
                    ImageIOUtil.writeImage(bim, fileName, dpi);
                }
                logger.info("Pdf转Png处理结束");
            } catch (IOException e){
                logger.info("Pdf转Png发生错误{}", JSON.toJSONString(e));
            }
        }
        return outputFilePath;
    }

    public static String pdfToPng(String pdfPath, String outputFilePath, int dpi, int flag){
        try {
            boolean retStatus = Pdf2Png.convert(pdfPath,outputFilePath,1.0f,flag,"");
        } catch (Exception e) {
            logger.info("Pdf转Png发生错误{}", JSON.toJSONString(e));
        }
        return outputFilePath;
    }
    
    private static  boolean createDirectory(String folder) {    
        File dir = new File(folder);     
        if (dir.exists()) {
            return true;    
        } else {    
            return dir.mkdirs();    
        }    
    }   

}
