package com.yizhi.application.forum.controller;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.accountUtil.AuthorizeQueryAccount;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.forum.application.constans.ForumConstans;
import com.yizhi.forum.application.feign.PostsClassifyClient;
import com.yizhi.forum.application.feign.PostsManageAccountClient;
import com.yizhi.forum.application.vo.domain.PostsClassifyVo;
import com.yizhi.forum.application.vo.domain.PostsManageAccountVo;
import com.yizhi.forum.application.vo.forum.PostsClassifyAccountVo;
import com.yizhi.forum.application.vo.forum.PostsClassifySettingVo;
import com.yizhi.forum.application.vo.forum.PostsManageAccountParamVo;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.OrgVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Api(tags = "管理端-帖子分类接口")
@RestController
@RequestMapping("/manage/postsClassify/")
public class PostsClassifyController {

    private static final Logger LOG = LoggerFactory.getLogger(PostsClassifyController.class);

    @Autowired
    private PostsClassifyClient postsClassifyClient;
    @Autowired
    private PostsManageAccountClient postsManageAccountClient;
    @Autowired
    private AuthorizeQueryAccount queryAccount;


    @PostMapping("/save")
    @ApiOperation(value = "分类添加")
    public Response save(@ApiParam("postsClassify") @RequestBody PostsClassifyVo postsClassifyVo) {
        String name = postsClassifyVo.getName();
        String content = postsClassifyVo.getDescription();

        if (name == null || name.trim().equals("") || name.length() > 20) {
            return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER3.getCode());
        }
        if (content != null && content.length() > 100) {
            return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER1.getCode());
        }
        if (postsClassifyClient.exsitsSameName(name)) {
            return Response.fail(InternationalEnums.TPPLANCONTROLLER6.getCode());
        }
        if (postsClassifyClient.save(postsClassifyVo)) {
            return Response.ok("操作成功！");
        } else {
            return Response.fail();
        }
    }

    @PostMapping("/update")
    @ApiOperation(value = "分类基本信息修改")
    public Response update(@ApiParam("postsClassify") @RequestBody com.yizhi.forum.application.vo.forum.PostsClassifyVo postsClassifyVo) {
        String name = postsClassifyVo.getName();
        String newName = postsClassifyVo.getNewName();
        postsClassifyVo.setName(null);
        Long id = postsClassifyVo.getId();
        if (id == null) {
            return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER2.getCode());
        }
        if (newName == null || newName.trim().equals("") || newName.length() > 20) {
            return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER3.getCode());
        }
        if (!name.equals(newName)) {
            postsClassifyVo.setName(newName);
            if (postsClassifyClient.exsitsSameName(newName)) {
                return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER4.getCode());
            }
        }
        PostsClassifyVo domainVo  = new PostsClassifyVo();
        BeanUtils.copyProperties(postsClassifyVo,domainVo);
        if (postsClassifyClient.update(domainVo)) {
            return Response.ok("操作成功！");
        } else {
            return Response.fail(InternationalEnums.TPPLANCONTROLLER6.getCode());
        }
    }

    @GetMapping("/move")
    @ApiOperation(value = "分类上下移")
    public Response update(@ApiParam("type；1-上移  2-下移 必填") @RequestParam("type") Integer type,
                           @ApiParam("分类id必填") @RequestParam("id") Long id) {
        PostsClassifyVo vo = postsClassifyClient.get(id);
        String result = "";
        if (vo == null) {
            result = "数据库没有该分类！";
            return Response.fail(result);
        }
        Integer move = postsClassifyClient.move(type, id);
        switch (move) {
            case 1:
                result = InternationalEnums.TPPLANCONTROLLER3.getCode();
                return Response.ok(result);
            case -1:
                result = InternationalEnums.TPPLANCONTROLLER4.getCode();
                break;
            case -2:
                result = InternationalEnums.TPPLANCONTROLLER5.getCode();
                break;
            case 0:
                result = InternationalEnums.TPPLANCONTROLLER6.getCode();
                break;
        }
        return Response.fail(result);
    }

    @GetMapping("/get")
    @ApiOperation(value = "分类回显")
    public Response get(@ApiParam("分类id必填") @RequestParam("id") Long id) {
        PostsClassifyVo vo = postsClassifyClient.get(id);
        return Response.ok(vo);
    }

    @GetMapping("/deleted")
    @ApiOperation(value = "分类删除")
    public Response deleted(@ApiParam("分类id必填") @RequestParam("id") Long id) {
        PostsClassifyVo vo = postsClassifyClient.get(id);
        if (vo == null) {
            return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER8.getCode());
        }
        Integer i = postsClassifyClient.deleted(id);
        switch (i) {
            case -1:
                return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER5.getCode());
            case 0:
                return Response.fail(InternationalEnums.TPPLANCONTROLLER6.getCode());
            case 1:
                return Response.ok("操作成功！");
            default:
                return Response.ok("操作成功！");
        }
    }

    /**
     * 为分类设置代管员
     *
     * @param vo
     * @return
     */
    @PostMapping("/setManager")
    @ApiOperation(value = "设置代管员")
    public Response setManager(@ApiParam("postsClassify") @RequestBody PostsManageAccountParamVo vo) {
        if (vo.getPostsClassifyId() == null) {
            return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER6.getCode());
        }
        if (!CollectionUtils.isEmpty(vo.getPostsManageAccounts())) {
            if (vo.getPostsManageAccounts().size() > 5) {
                return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER7.getCode());
            }
        }
        if (postsManageAccountClient.save(vo)) {
            return Response.ok("操作成功！");
        } else {
            return Response.fail(InternationalEnums.TPPLANCONTROLLER6.getCode());
        }
    }

    /**
     * 获取代管员列表
     *
     * @param postsClassifyId
     * @return
     */
    @GetMapping("/getManager")
    @ApiOperation(value = "获取代管员列表", response = PostsManageAccountVo.class)
    public Response<List<PostsManageAccountVo>> getManager(@ApiParam("分类id") @RequestParam("postsClassifyId") Long postsClassifyId) {
        PostsClassifyVo vo = postsClassifyClient.get(postsClassifyId);
        if (vo == null) {
            return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER8.getCode());
        }
        List<com.yizhi.forum.application.vo.forum.PostsManageAccountVo> managers = postsManageAccountClient.getManager(postsClassifyId);
        List<com.yizhi.forum.application.vo.forum.PostsManageAccountVo> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(managers)) {
            List<Long> accountIds = new ArrayList<>(managers.size());
            managers.forEach(a -> {
                accountIds.add(a.getAccountId());
            });
            Map<Long, AccountVO> accountVOMap = queryAccount.queryAccountByIds(accountIds);
            if (accountVOMap != null) {
                managers.forEach(a -> {
                    AccountVO accountVO = accountVOMap.get(a.getAccountId());
                    if (accountVO != null) {
                        a.setAccountName(accountVO.getName());
                        a.setAccountFullName(accountVO.getFullName());
                        a.setWorkNum(accountVO.getWorkNum());
                    }
                });
            }
        }
        return Response.ok(managers);
    }

    /**
     * 更新论坛设置
     *
     * @param vo
     * @return
     */
    @PostMapping("/updateSetting")
    @ApiOperation(value = "分类论坛设置修改")
    public Response updateSetting(@ApiParam("设置vo") @RequestBody PostsClassifySettingVo vo) {

        Long id = vo.getId();
        if (id == null) {
            return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER2.getCode());
        }
        if (postsClassifyClient.updateSetting(vo)) {
            return Response.ok("操作成功！");
        } else {
            return Response.fail(InternationalEnums.TPPLANCONTROLLER6.getCode());
        }
    }

    /**
     * 获取论坛设置
     *
     * @param id
     * @return
     */
    @GetMapping("/getSetting")
    @ApiOperation(value = "获取论坛设置数据", response = PostsClassifySettingVo.class)
    public Response<PostsClassifySettingVo> getSetting(@ApiParam("设置vo") @RequestParam("id") Long id) {

        PostsClassifyVo vo = postsClassifyClient.get(id);
        if (vo == null) {
            return Response.fail(InternationalEnums.POSTSCLASSIFYCONTROLLER8.getCode());
        }
        PostsClassifySettingVo settingVo = postsClassifyClient.getSetting(id);
        List<PostsClassifyAccountVo> classifyAccountVos = settingVo.getPostsClassifyAccountVos();
        //实时获取用户真实姓名或部门名称
        if (!CollectionUtils.isEmpty(classifyAccountVos)) {
            List<Long> orgIds = new ArrayList<>(classifyAccountVos.size());
            List<Long> accountIds = new ArrayList<>(classifyAccountVos.size());
            classifyAccountVos.forEach(a -> {
                if (ForumConstans.ORG.equals(a.getAccountType())) {
                    orgIds.add(a.getAccountId());
                } else if (ForumConstans.ACCOUNT.equals(a.getAccountType())) {
                    accountIds.add(a.getAccountId());
                }
            });
            Map<Long, AccountVO> accountVOMap = queryAccount.queryAccountByIds(accountIds);
            Map<Long, OrgVO> orgVOMap = queryAccount.queryOrgByIds(orgIds);

            classifyAccountVos.forEach(a -> {
                String accountName = null;
                String accountFullName = null;
                String workNum = null;
                if (ForumConstans.ORG.equals(a.getAccountType())) {
                    if (orgVOMap != null) {
                        OrgVO orgVO = orgVOMap.get(a.getAccountId());
                        if (orgVO != null) {
                            accountName = orgVO.getName();
                        }
                    }
                } else if (ForumConstans.ACCOUNT.equals(a.getAccountType())) {
                    if (accountVOMap != null) {
                        AccountVO accountVO = accountVOMap.get(a.getAccountId());
                        if (accountVO != null) {
                            accountName = accountVO.getName();
                            accountFullName = accountVO.getFullName();
                            workNum = accountVO.getWorkNum();
                        }
                    }
                }
                a.setAccountName(accountName);
                a.setAccountFullName(accountFullName);
                a.setWorkNum(workNum);
            });
        }
        return Response.ok(settingVo);
    }

    @ApiOperation(value = "分类分页", response = PostsClassifySettingVo.class)
    @GetMapping("/getPage")
    public Response<Page<PostsClassifyVo>> getPage(@ApiParam("分类名称") @RequestParam(value = "name", required = false) String name,
                                                   @ApiParam("默认第一页") @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
                                                   @ApiParam("默认10条") @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {

        return Response.ok(postsClassifyClient.getPage(name, pageNo, pageSize));
    }
}
