package com.yizhi.application.portal.controller;

import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.cache.distributedlock.impl.RedisDistributedLock;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.api.FunctionDisplayConfigApiClients;
import com.yizhi.site.application.vo.domain.FunctionDisplayConfigVo;
import com.yizhi.site.application.vo.site.FunctionDisplayConfigVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 18:07 2019/4/29
 * @Modified By
 */
@Api(tags = "管理端-显示配置", description = "功能项显示")
@RestController
@RequestMapping("/manage/functionDispla/config")
public class FunctionDisplayConfigController {

    @Autowired
    private FunctionDisplayConfigApiClients configApiClients;

    @Autowired
    private RedisDistributedLock distributedLock;

    @PostMapping("/update")
    @ApiOperation(value = "修改显示配置")
    public Response update(@RequestBody FunctionDisplayConfigVO vos) {
        RequestContext rt = ContextHolder.get();
        String lockKey = "functionDisplayConfig.update."+rt.getSiteId();
        distributedLock.lock(lockKey);
        Integer ret = configApiClients.update(Arrays.asList(vos));
        if(Integer.valueOf(1).equals(ret)){
            Response.fail(InternationalEnums.FUNCTIONDISPLAYCONFIGCONTROLLER1.getCode());
        }else if(Integer.valueOf(2).equals(ret)){
            Response.fail(InternationalEnums.FUNCTIONDISPLAYCONFIGCONTROLLER2.getCode());
        }
        distributedLock.releaseLock(lockKey);
        return Response.ok(InternationalEnums.FUNCTIONDISPLAYCONFIGCONTROLLER3.getCode());
    }

    @GetMapping("/site/all/get")
    @ApiOperation(value = "修改显示配置",response = FunctionDisplayConfigVO.class)
    public Response<FunctionDisplayConfigVO> getAllBySiteId(){
        RequestContext rt = ContextHolder.get();
        String lockKey = "functionDisplayConfig.get.all"+rt.getSiteId();
        distributedLock.lock(lockKey);
        List<FunctionDisplayConfigVO> retData = null;
        List<FunctionDisplayConfigVo> data = configApiClients.getAllBySiteId();
        if(!CollectionUtils.isEmpty(data)){
            retData = new ArrayList<>();
            for(FunctionDisplayConfigVo item : data){
                FunctionDisplayConfigVO vo = new FunctionDisplayConfigVO();
                BeanUtils.copyProperties(item, vo);
                retData.add(vo);
            }
        }
        distributedLock.releaseLock(lockKey);
        return Response.ok(retData);
    }


}
