package com.yizhi.application.portal.controller;

import java.util.List;

import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.course.application.vo.domain.CourseEntityVo;
import com.yizhi.live.application.feign.LiveActivityClient;
import com.yizhi.live.application.vo.LiveActivityResultVO;
import com.yizhi.live.application.vo.LiveActivityVO;
import com.yizhi.site.application.feign.PortalManageFeignClients;
import com.yizhi.site.application.vo.site.PlateListVO;
import com.yizhi.site.application.vo.site.PortalPreviewVO;
import com.yizhi.site.application.vo.site.TemplateListVO;
import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.training.application.vo.domain.TrainingProjectVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags = "门户管理")
@RestController
@RequestMapping("/manage/portal")
public class SitePortalViewController {

	private static final Logger LOG = LoggerFactory.getLogger(SitePortalViewController.class);

	@Autowired
	private PortalManageFeignClients portalManages;
	@Autowired
	private TrainingProjectClient projectClient;
	@Autowired
	private CourseClient courseClient;
	@Autowired
	private LiveActivityClient liveClient;

	@ApiOperation(value = "首页预览（PC、微信）", notes = "返回首页", response = PortalPreviewVO.class)
	@GetMapping(value = { "/home/preview", "/home/view" })
	public Response<PortalPreviewVO> previewPortal(
			@ApiParam(name = "terminalId", value = "终端ID", required = true) String terminalId) {
		try {
			if (terminalId.equals("") || terminalId.equals(null)) {
				return Response.fail(InternationalEnums.SITECLASSIFYMANAGECOMTROLLER2.getName());
			}
			RequestContext context = ContextHolder.get();
			PortalPreviewVO previewPortal = portalManages.previewPortal(Long.valueOf(terminalId));
			if (previewPortal != null) {
				previewPortal.setSiteId(ContextHolder.get().getSiteId());
				previewPortal.setTerminalId(Long.valueOf(terminalId));

				List<TemplateListVO> templateList = previewPortal.getTemplateList();
				if (templateList != null && templateList.size() > 0) {
					formatTemplateList(templateList, context.getAccountId());
				}
			}
			return Response.ok(previewPortal);
		} catch (Exception e) {
			LOG.error("首页预览（PC、微信）:", e);
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}

	private void formatTemplateList(List<TemplateListVO> templateList, Long accountId) {
		for (TemplateListVO vo : templateList) {
			Integer moduleType = vo.getModuleType();
			List<PlateListVO> plateList = vo.getPlateList();
			for (PlateListVO pvo : plateList) {
				Long linkContent = pvo.getLinkContent();
				if(linkContent == null){
					continue;
				}
				if (moduleType == 2) { // 培训
//					TrainingProject one = new TrainingProject();
//					one.setId(100000000001399999L);
//					one.setName("标题");
//					one.setLogoImg("http://img5.duitang.com/uploads/item/201412/05/20141205180440_zmf4Y.thumb.700_0.jpeg");
//					one.setStartTime(new Date());
//					one.setEndTime(new Date());
					TrainingProjectVo one = null;
					try {
						one = projectClient.getOne(linkContent);
					} catch (Exception e) {
						LOG.error("培训异常:" + e);
					}
					if (one == null) {
						continue;
					}
					pvo.setStartTime(one.getStartTime());
					pvo.setEndTime(one.getEndTime());
				} else if (moduleType == 3) { // 课程
//					CourseVo courseVo = new CourseVo();
//					courseVo.setAuthorUnit("authorUnit");
					
					/*
					CourseDetailsVo cdvo = null;
					try {
						//这个接口是详情接口，查询了很多不必要的东西，因此重写一个接口,只查询作者。
						//cdvo = courseClient.get(linkContent, accountId);
						//只调用了作者
					} catch (Exception e) {
						LOG.error("课程异常:" + e);
					}
					if (cdvo == null) {
						continue;
					}
					CourseVo courseVo = cdvo.getCourseVo();
					if (courseVo == null) {
						continue;
					}
					pvo.setAuthor(courseVo.getAuthorUnit());
					*/
					CourseEntityVo c=courseClient.view(linkContent);
					if(c==null) {
						continue;
					}
					pvo.setAuthor(c.getAuthorUnit());
//					if(cdvo.getLevel().equals("") || cdvo.getLevel().equals(null)){
//						pvo.setScore("0");
//					}else{
//						pvo.setScore(String.valueOf(cdvo.getLevel()));
//					}
				} else if (moduleType == 5) { // 直播
//					LiveActivity live = new LiveActivity();
//					live.setStartTime(new Date());
//					live.setEndTime(new Date());
//					live.setAnchor("anchor");
//					live.setScope(100);
					
					LiveActivityVO live = null;
					try {
						LiveActivityResultVO liveActivity = liveClient.get(linkContent);
						live = liveActivity.getLiveActivity();
					} catch (Exception e) {
						LOG.error("直播异常:" + e);
					}
					if (live == null) {
						continue;
					}
					pvo.setStartTime(live.getStartTime());
					pvo.setEndTime(live.getEndTime());
					pvo.setAuthor(live.getAnchor());
//					pvo.setScore(live.getScope());
				}
			}
		}
	}

}
