package com.yizhi.application.project.controller;


import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.training.application.feign.TpClassificationClient;
import com.yizhi.training.application.vo.domain.TpClassificationVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 培训项目分类表 前端控制器
 * </p>
 *
 * @author shengchenglong
 * @since 2018-03-23
 */
@Api(tags = "培训项目分类接口")
@RestController
@RequestMapping("/manage/tpClassification")
public class TpClassificationController {

    @Autowired
    TpClassificationClient tpClassificationClient;

    private static final Logger LOGGER = LoggerFactory.getLogger(TpClassificationController.class);

    @PostMapping("/save")
    @ApiOperation(value = "新增培训项目分类", notes = "返回操作状态")
    public Response save(
            @RequestBody TpClassificationVo tpClassification
    ) {

        if (null == tpClassification.getName() || StringUtils.isEmpty(tpClassification.getName().trim())) {
            return Response.fail(InternationalEnums.TPCLASSIFICATIONCONTROLLER.getCode());
        }
        RequestContext requestContext = ContextHolder.get();
        tpClassification.setSiteId(requestContext.getSiteId());
        tpClassification.setOrgId(requestContext.getOrgId());
        tpClassification.setCompanyId(requestContext.getCompanyId());
        tpClassification.setCreateById(requestContext.getAccountId());
        tpClassification.setCreateByName(requestContext.getAccountName());
        tpClassification.setName(tpClassification.getName().trim());
        tpClassification.setDeleted(0);
        Boolean f = tpClassificationClient.save(tpClassification);
        if (f) {
            LOGGER.info("分类保存成功");
            return Response.ok();

        } else {
            LOGGER.info("分类保存失败");
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

    }

    @PostMapping("/update")
    @ApiOperation(value = "修改培训项目分类", notes = "返回状态")
    public Response update(
            @RequestBody TpClassificationVo updateTpClassification
//            @ApiParam(value = "培训项目id") @RequestParam("id") Long id,
//            @ApiParam(value = "培训项目分类名") @RequestParam("name") String name,
//            @ApiParam(value = "培训项目分类描述") @RequestParam("description") String description
    ) {

        if (null == updateTpClassification.getName() || StringUtils.isEmpty(updateTpClassification.getName().trim())) {
            return Response.fail(InternationalEnums.TPCLASSIFICATIONCONTROLLER.getCode());
        }
        TpClassificationVo tpClassification = tpClassificationClient.view(updateTpClassification.getId());
        if (StringUtils.isEmpty(tpClassification)) {
            return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
        }
        if (!StringUtils.isEmpty(updateTpClassification.getName())) {
            tpClassification.setName(updateTpClassification.getName().trim());
        }
        if (!StringUtils.isEmpty(updateTpClassification.getDescription())) {
            tpClassification.setDescription(updateTpClassification.getDescription());
        }
        Boolean f = tpClassificationClient.update(tpClassification);
        if (f) {
            LOGGER.info("分类修改成功");
            return Response.ok();

        } else {
            LOGGER.info("分类修改失败");
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @GetMapping("/view")
    @ApiOperation(value = "获得培训项目分类", notes = "返回新增培训项目分类", response = TpClassificationVo.class)
    public Response<TpClassificationVo> view(
            @ApiParam(value = "培训项目id") @RequestParam("id") Long id
    ) {
        TpClassificationVo tpClassification = tpClassificationClient.view(id);
        return Response.ok(tpClassification);
    }

    @GetMapping("/list")
    @ApiOperation(value = "获得培训项目分类", notes = "返回新增培训项目分类", response = TpClassificationVo.class)
    public Response<List<TpClassificationVo>> list() {
        RequestContext requestContext = ContextHolder.get();
        return Response.ok(tpClassificationClient.list(requestContext));
    }

    @PostMapping("/delete")
    @ApiOperation(value = "逻辑删除培训项目分类", notes = "返回操作状态")
    public Response delete(
            @RequestBody TpClassificationVo tpClassification
//            @ApiParam(value = "培训项目id") @RequestParam("id") Long id
    ) {
        TpClassificationVo tpClassification1 = tpClassificationClient.view(tpClassification.getId());
        tpClassification1.setDeleted(1);
        tpClassification1.setUpdateById(ContextHolder.get().getAccountId());
        tpClassification1.setUpdateByName(ContextHolder.get().getAccountName());
        tpClassification1.setUpdateTime(new Date());
        Boolean f = tpClassificationClient.tpClassificationDelete(tpClassification1);
        if (f) {
            LOGGER.info("分类删除成功");
            return Response.ok();

        } else {
            LOGGER.info("分类删除失败");
            return Response.fail();
        }
    }

}



