package com.yizhi.application.report.course;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.course.application.feign.CourseReportClient;
import com.yizhi.course.application.vo.ReportStudyCourseAccountViewVo;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;



/**
 * 按照用户统计---详情---导出Excel
 * @author wangfeida
 *
 */


@Component
public class CourseAccountGroupViewExportExcel extends AbstractDefaultTask<String, Map<String, Object>> {

	private static final Logger logger = LoggerFactory.getLogger(CourseAccountGroupViewExportExcel.class);

	@Autowired
	private CourseReportClient courseReportClient;

	@Override
	protected String execute(Map<String, Object> map) {
		// TODO Auto-generated method stub
		String upLoadUrl = null;
		Long accountId = (Long) map.get("accountId");
		Long searchId=(Long) map.get("searchId");
		Long companyId = (Long) map.get("companyId");
		Long siteId = (Long) map.get("siteId");
		String startDate = (String) map.get("startDate");
		String endDate = (String) map.get("endDate");
		String kwd = (String) map.get("kwd");
		Long taskId=(Long) map.get("taskId");
		Date submitTime=(Date) map.get("submitTime");
		String serialNo=(String) map.get("serialNo");
		String taskName=(String) map.get("taskName");
		
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
		working(taskContext);
		
		
		List<LinkedHashMap<String, String>> listLinkedHashMap=new ArrayList<LinkedHashMap<String, String>>();
		Integer pageNo = 2;
		Integer pageSize = 30;
		Map<String, Object> mapRecord = new HashMap<String, Object>();
		mapRecord = courseReportClient.courseAccountGroupView(searchId, kwd, startDate, endDate, pageNo - 1, pageSize);
		Object object = mapRecord.get("list");
		ArrayList<LinkedHashMap<String, String>> listRecord = (ArrayList<LinkedHashMap<String, String>>) object;

		String accountName = (String) mapRecord.get("accountName");
		String pageTotalString = mapRecord.get("pageTotal").toString();
		Integer pageTotal = Integer.valueOf(pageTotalString);

		if (listRecord != null && listRecord.size() > 0) {
			listLinkedHashMap.addAll(listRecord);
			int num = pageTotal / pageSize + 1;
 			for (int i = 2; i <= num; i++) {
				mapRecord = courseReportClient.courseAccountGroupView(searchId, kwd, startDate, endDate, i, pageSize);
				object = mapRecord.get("list");
				listRecord = (ArrayList<LinkedHashMap<String, String>>) object;

				if (listRecord == null || listRecord.size() == 0) {
					break;
				}
				listLinkedHashMap.addAll(listRecord);
			}
		}
		
		List<ReportStudyCourseAccountViewVo> list = new ArrayList<ReportStudyCourseAccountViewVo>();
		ReportStudyCourseAccountViewVo rscav=null;
		
		Date date=null;
		try {
			for (Map mapp : listLinkedHashMap) {
				rscav = new ReportStudyCourseAccountViewVo();
				String courseNo = (String) mapp.get("courseNo");
				String courseName = (String) mapp.get("courseName");
				Integer state = Integer.valueOf(mapp.get("state") == null ? "0" : (mapp.get("state").toString()));
				Integer totalCount = Integer.valueOf(mapp.get("totalCount") == null ? "0" : (mapp.get("totalCount").toString()));

				if (mapp.get("startTime") != null) {
					Long ms = Long.parseLong(mapp.get("startTime").toString());
					date = new Date(ms);
				}

				Date startTime = date;
				Double totalDuration = Double.valueOf(mapp.get("totalDuration") == null ? "0.0" : (mapp.get("totalDuration").toString()));
				String accountName1 = (String) mapp.get("accountName");
				String accountFullName = (String) mapp.get("accountFullName");
				String orgName = (String) mapp.get("orgName");
				Integer accountState = Integer.valueOf(mapp.get("accountState") == null ? "0" : (mapp.get("accountState").toString()));
				Integer canState = Integer.valueOf(mapp.get("canState") == null ? "0" : (mapp.get("canState").toString()));
				Integer learnScore = Integer.valueOf(mapp.get("learnScore") == null ? "0" : (mapp.get("learnScore").toString()));
				rscav.setCourseNo(courseNo);
				rscav.setCourseName(courseName);
				rscav.setState(state);
				rscav.setTotalCount(totalCount);
				rscav.setStartTime(startTime);
				rscav.setTotalDuration(totalDuration.toString());
				rscav.setAccountName(accountName1);
				rscav.setAccountFullName(accountFullName);
				rscav.setOrgName(orgName);
				rscav.setAccountState(accountState);
				rscav.setCanState(canState);
				rscav.setLearnScore(learnScore);
				list.add(rscav);
			}
		}catch (Exception e){
			e.printStackTrace();
			logger.error("",e);
		}
		
		
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		
		SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMddHHmmss");
		
		
		try {
			// excel生成过程: excel-->sheet-->row-->cell
			// 第一步，创建一个Excel文件
			HSSFWorkbook wb = new HSSFWorkbook();
			// 最大限度是50000
			// 第二步，在webbook中添加一个sheet,对应Excel文件中的sheet
			HSSFSheet sheet = wb.createSheet(accountName+"学习明细");
			// 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
			HSSFRow row = sheet.createRow((int) 0);
			// 第四步，创建单元格，并设置值表头 设置表头居中
			HSSFCellStyle style = wb.createCellStyle();
			style.setAlignment(HorizontalAlignment.CENTER); // 创建一个居中格式
			// 合并单元格
			CellRangeAddress cra = new CellRangeAddress(0, 0, 0, 12); // 起始行, 终止行, 起始列, 终止列
			sheet.addMergedRegion(cra);
			HSSFCell cell = row.createCell((short) 0);
			cell.setCellValue(accountName+"学习明细");
			cell.setCellStyle(style);

			// 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
			HSSFRow row2 = sheet.createRow((int) 1);
			// 第四步，创建单元格
			CellRangeAddress cra2 = new CellRangeAddress(1, 1, 0, 3);
			sheet.addMergedRegion(cra2);
			HSSFCell cell2 = row2.createCell((short) 0);
			cell2.setCellValue("统计周期： " + startDate + "~" + endDate);

			HSSFRow row3 = sheet.createRow((int) 2);
			row3.createCell((short) 0).setCellValue("用户名");
			row3.createCell((short) 1).setCellValue("姓名");
			row3.createCell((short) 2).setCellValue("课程名称");
			row3.createCell((short) 3).setCellValue("课程编码");
			row3.createCell((short) 4).setCellValue("学习状态");
			row3.createCell((short) 5).setCellValue("学习次数");
			row3.createCell((short) 6).setCellValue("开始学习时间");
			row3.createCell((short) 7).setCellValue("课程得分");
			row3.createCell((short) 8).setCellValue("学习时长(分钟)");
			row3.createCell((short) 9).setCellValue("可见状态");
			row3.createCell((short) 10).setCellValue("用户状态");
			row3.createCell((short) 11).setCellValue("所在部门");

			// 第五步，写入实体数据 实际应用中这些数据从数据库得到，
			ReportStudyCourseAccountViewVo rscv=null;
			if(!CollectionUtils.isEmpty(list)) {
			for (int i = 0; i < list.size(); i++) {
				row = sheet.createRow(i + 3);
				rscv = list.get(i);
				
				if(rscv!=null) {
					// 第四步，创建单元格，并设置值
					row.createCell((short) 0).setCellValue(rscv.getAccountName());
					row.createCell((short) 1).setCellValue(rscv.getAccountFullName());
					row.createCell((short) 2).setCellValue(rscv.getCourseName());
					row.createCell((short) 3).setCellValue(rscv.getCourseNo());
					String state=null;
					if(rscv.getState()==0) {
						state="未开始";
					}
					if(rscv.getState()==1) {
						state="进行中";
					}
					if(rscv.getState()==2) {
						state="已完成";
					}
					
					row.createCell((short) 4).setCellValue(state);
					row.createCell((short) 5).setCellValue(rscv.getTotalCount());
					if(rscv.getStartTime()!=null) {
						row.createCell((short) 6).setCellValue(df.format(rscv.getStartTime()));
					}
					row.createCell((short) 7).setCellValue(rscv.getLearnScore());
					row.createCell((short) 8).setCellValue(rscv.getTotalDuration());
					row.createCell((short) 9).setCellValue(rscv.getCanState()==0?"可见":"不可见");
					row.createCell((short) 10).setCellValue(rscv.getAccountState()==0?"禁用":"启用");
					row.createCell((short) 11).setCellValue(rscv.getOrgName());
					//taskDetail(taskContext.getTaskId(), accountName+"学习明细统计第+" + i + "+行成功");
				}
				
			}
			}

			String fileName = accountName+"学习明细统计" + df2.format(submitTime) + ".xls";
			String requestPath = FileConstant.SAVE_PATH;
			//String requestPath = "E:\\home";
			File fileDir = new File(requestPath);
			if (!fileDir.exists()) {
				fileDir.mkdir();
			}
			String path = requestPath + fileName;
			FileOutputStream os = null;
			File file = null;
			try {
				os = new FileOutputStream(path);
				wb.write(os);
				// 阿里云返回url
				upLoadUrl = OssUpload.upload(path, fileName);
				file = new File(path);
				success(taskContext, "成功", upLoadUrl);
			} catch (Exception e1) {
				e1.printStackTrace();
				fail(taskContext, "写入过程中发生错误");
				logger.error("上传过程中发生错误，请查看日志");
			} finally {
				if (os != null) {
					os.close();
				}
				if (wb != null) {
					wb.close();
				}
				if (file != null) {
					file.delete();
				}
			}

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			fail(taskContext, "按用户统计---详情---下载学习明细导出过程中发生错误，请查看日志");
			logger.error("按用户统计---详情---下载学习明细导出过程中发生错误，请查看日志");
		}
		return upLoadUrl;
	}
}
