package com.yizhi.application.report.course;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.vo.ReportStudyCourseChartsVo;
import com.yizhi.statistics.application.course.vo.*;
import com.yizhi.statistics.application.feign.StatisticsCourseClient;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.plugins.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 在线课程报表统计
 *
 * @author mei
 *
 */

@Api(tags = "报表统计-在线课程", description = "报表统计-在线课程")
@RestController
@RequestMapping("/manage/report/course")
public class ReportCourse {


	private static final Logger logger = LoggerFactory.getLogger(ReportCourse.class);

	@Autowired
	private StatisticsCourseClient statisticsCourseClient;

	@GetMapping("/test")
	public Response<ReportStudyCourseChartsVo> Test() {
		statisticsCourseClient.AsynchronousCourse(null, null);
		return Response.ok("success");
	}

/**
 * 图形报表
 * @param startDate
 * @param endDate
 * @return
 */
	@ApiOperation(value = "图表数据统计", notes = "图表数据统计", response = ReportStudyCourseChartsVo.class)
	@GetMapping("/chart/group")
	public Response<ReportStudyCourseChartsVo> chartGroup(
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate) {
		List<com.yizhi.statistics.application.course.vo.ReportStudyCourseChartsVo> list = new ArrayList<>();
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId = requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		logger.info("companyId:{}", companyId);
		logger.info("siteId:{}", siteId);
		logger.info("adminId:{}",adminId);
		logger.info("isAdmin:{}",isAdmin);
		System.out.println("companyId"+companyId);
		System.out.println("siteId"+siteId);
		System.out.println("adminId"+adminId);
		System.out.println("isAdmin"+isAdmin);
		list = statisticsCourseClient.chartGroup(startDate, endDate, companyId, siteId, adminId, isAdmin);
		return Response.ok(list);
	}


	/**
	 * 按照课程统计
	 * @param startDate
	 * @param endDate
	 * @param kwd
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	@ApiOperation(value = "按课程统计", notes = "按课程统计", response = com.yizhi.statistics.application.course.vo.ReportStudyCourseVo.class)
	@GetMapping("/group")
	public Response<com.yizhi.statistics.application.course.vo.ReportStudyCourseVo> courseGroup(
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "课程关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd,
			@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {

		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		CourseGroupParam courseGroupParam=new CourseGroupParam();
		courseGroupParam.setStartDate(startDate);
		courseGroupParam.setEndDate(endDate);
		courseGroupParam.setKwd(kwd);
		courseGroupParam.setPageNo(pageNo);
		courseGroupParam.setPageSize(pageSize);
		courseGroupParam.setCompanyId(companyId);
		courseGroupParam.setSiteId(siteId);
		courseGroupParam.setAdminId(adminId);
		courseGroupParam.setIsAdmin(isAdmin);
		Page<com.yizhi.statistics.application.course.vo.ReportStudyCourseVo> page = statisticsCourseClient.courseGroup(courseGroupParam);
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<ReportStudyCourseVo> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", total);
		return Response.ok(list, pageMap);
	}



	/**
	 * 按照课程统计下载
	 * @param request
	 * @param startDate
	 * @param endDate
	 * @param kwd
	 * @return
	 */
	@ApiOperation(value = "按课程统计导出Excel", notes = "按照课程统计导出Excel")
	@GetMapping("/group/export")
	public Response<String> courseGroupExportExcel(HttpServletRequest request,
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "课程关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd) {

		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="在线课程-按课程统计-下载结果数据-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		CourseGroupParam courseGroupParam=new CourseGroupParam();
		courseGroupParam.setStartDate(startDate);
		courseGroupParam.setEndDate(endDate);
		courseGroupParam.setKwd(kwd);
		courseGroupParam.setCompanyId(companyId);
		courseGroupParam.setSiteId(siteId);
		courseGroupParam.setAdminId(adminId);
		courseGroupParam.setIsAdmin(isAdmin);
		courseGroupParam.setSerialNo(serialNo);
		courseGroupParam.setTaskId(taskId);
		courseGroupParam.setSubmitTime(submitTime);
		courseGroupParam.setTaskName(taskName);
		statisticsCourseClient.courseGroupExcel(courseGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}


	/**
	 * 按课程统计详情
	 * @param startDate
	 * @param endDate
	 * @param courseId
	 * @param orgKwd
	 * @param accountKwd
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	@ApiOperation(value = "按课程统计详情", notes = "按课程统计详情", response = ReportStudyCourseViewVo.class)
	@GetMapping("/group/view")
	public Response<ReportStudyCourseViewVo> courseGroupView(
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "课程id", required = true) @RequestParam(name = "courseId", required = true) Long courseId,
			@ApiParam(value = "部门名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,
			@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,
			@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		CourseGroupViewParam courseGroupViewParam=new CourseGroupViewParam();
		courseGroupViewParam.setCourseId(courseId);
		courseGroupViewParam.setOrgKwd(orgKwd);
		courseGroupViewParam.setAccountKwd(accountKwd);
		courseGroupViewParam.setPageNo(pageNo);
		courseGroupViewParam.setPageSize(pageSize);
		courseGroupViewParam.setStartDate(startDate);
		courseGroupViewParam.setEndDate(endDate);
		courseGroupViewParam.setCompanyId(companyId);
		courseGroupViewParam.setSiteId(siteId);
		courseGroupViewParam.setAdminId(adminId);
		courseGroupViewParam.setIsAdmin(isAdmin);
		Page<ReportStudyCourseViewVo> page = statisticsCourseClient.courseGroupView(courseGroupViewParam);
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<ReportStudyCourseViewVo> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}
		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal",total);
		return Response.ok(list, pageMap);
	}



	/**
	 * 按课程统计详情导出Excel
	 * @param request
	 * @param startDate
	 * @param endDate
	 * @param courseId
	 * @param orgKwd
	 * @param accountKwd
	 * @return
	 */
	@ApiOperation(value = "按课程统计详情导出Excel", notes = "按照课程统计导出Excel")
	@GetMapping("/group/view/export")
	public Response<String> CourseGroupViewExportExcel(HttpServletRequest request,
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "课程id", required = false) @RequestParam(name = "courseId", required = true) Long courseId,
			@ApiParam(value = "部门名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,
			@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,
            @ApiParam(value = "是否包含所有学习数据", required = true) @RequestParam(name = "isAllData") boolean isAllData) {

		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="在线课程-按课程统计-课程详情-下载课程学习明细-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();
		CourseGroupViewParam courseGroupViewParam=new CourseGroupViewParam();
		courseGroupViewParam.setCourseId(courseId);
		courseGroupViewParam.setOrgKwd(orgKwd);
		courseGroupViewParam.setAccountKwd(accountKwd);
		courseGroupViewParam.setStartDate(startDate);
		courseGroupViewParam.setEndDate(endDate);
		courseGroupViewParam.setCompanyId(companyId);
		courseGroupViewParam.setSiteId(siteId);
		courseGroupViewParam.setAdminId(adminId);
		courseGroupViewParam.setIsAdmin(isAdmin);
		courseGroupViewParam.setSerialNo(serialNo);
		courseGroupViewParam.setTaskId(taskId);
		courseGroupViewParam.setSubmitTime(submitTime);
		courseGroupViewParam.setTaskName(taskName);
		courseGroupViewParam.setAllData(isAllData);
		statisticsCourseClient.courseGroupViewExcel(courseGroupViewParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}



	/**
	 * 按照用户统计
	 * @param startDate
	 * @param endDate
	 * @param orgKwd
	 * @param accountKwd
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	@ApiOperation(value = "按用户统计", notes = "按用户统计", response = ReportStudyCourseAccountVo.class)
	@GetMapping("/account/group")
	public Response<ReportStudyCourseAccountVo> courseAccountGroup(
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,
			@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,
			@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();

		CourseAccountGroupParam courseAccountGroupParam=new CourseAccountGroupParam();

		courseAccountGroupParam.setOrgKwd(orgKwd);
		courseAccountGroupParam.setAccountKwd(accountKwd);
		courseAccountGroupParam.setPageNo(pageNo);
		courseAccountGroupParam.setPageSize(pageSize);
		courseAccountGroupParam.setStartDate(startDate);
		courseAccountGroupParam.setEndDate(endDate);
		courseAccountGroupParam.setCompanyId(companyId);
		courseAccountGroupParam.setSiteId(siteId);
		courseAccountGroupParam.setAdminId(adminId);
		courseAccountGroupParam.setIsAdmin(isAdmin);

	   Page<ReportStudyCourseAccountVo>	page = statisticsCourseClient.courseAccountGroup(courseAccountGroupParam);
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<ReportStudyCourseAccountVo> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}

		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", total);
		return Response.ok(list, pageMap);
	}




	/**
	 * 按照用户统计导出
	 * @param request
	 * @param startDate
	 * @param endDate
	 * @param orgKwd
	 * @param accountKwd
	 * @return
	 */
	@ApiOperation(value = "按用户统计导出Excel----下载学习统计数据", notes = "按用户统计导出Excel")
	@GetMapping("/account/group/export")
	public Response<String> courseAccountGroupExportExcel(HttpServletRequest request,
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,
			@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd) {


		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="在线课程-按课程统计-课程详情-下载课程学习明细-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();

		CourseAccountGroupParam courseAccountGroupParam=new CourseAccountGroupParam();

		courseAccountGroupParam.setOrgKwd(orgKwd);
		courseAccountGroupParam.setAccountKwd(accountKwd);
		courseAccountGroupParam.setStartDate(startDate);
		courseAccountGroupParam.setEndDate(endDate);
		courseAccountGroupParam.setCompanyId(companyId);
		courseAccountGroupParam.setSiteId(siteId);
		courseAccountGroupParam.setAdminId(adminId);
		courseAccountGroupParam.setIsAdmin(isAdmin);
		courseAccountGroupParam.setSerialNo(serialNo);
		courseAccountGroupParam.setTaskId(taskId);
		courseAccountGroupParam.setSubmitTime(submitTime);
		courseAccountGroupParam.setTaskName(taskName);
		statisticsCourseClient.courseAccountGroupExportExcel(courseAccountGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}




	/**
	 *  下载用户学习明细
	 * @param request
	 * @param startDate
	 * @param endDate
	 * @param orgKwd
	 * @param accountKwd
	 * @return
	 */
		@ApiOperation(value = "按用户统计---下载学习明细----导出Excel", notes = "按用户统计下载学习明细导出Excel")
		@GetMapping("/account/group/details/export")
		public Response<String> courseAccountGroupDetailsExportExcel(HttpServletRequest request,
				@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
				@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
				@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "orgKwd", required = false) String orgKwd,
				@ApiParam(value = "用户关键字", required = false) @RequestParam(name = "accountKwd", required = false) String accountKwd,
			    @ApiParam(value = "是否包含所有学习数据", required = true) @RequestParam(name = "isAllData") boolean isAllData) {
			Date submitTime = new Date();
			Long taskId = submitTime.getTime();
			String serialNo="USER-EXPORT-"+taskId;
			String taskName="在线课程-按用户统计-课程详情-下载课程学习明细-"+taskId;
			RequestContext requestContext = ContextHolder.get();
			Long companyId = requestContext.getCompanyId();
			Long siteId =requestContext.getSiteId();
			Long adminId=requestContext.getAccountId();
			Boolean isAdmin=requestContext.isAdmin();

			CourseAccountGroupParam courseAccountGroupParam=new CourseAccountGroupParam();

			courseAccountGroupParam.setOrgKwd(orgKwd);
			courseAccountGroupParam.setAccountKwd(accountKwd);
			courseAccountGroupParam.setStartDate(startDate);
			courseAccountGroupParam.setEndDate(endDate);
			courseAccountGroupParam.setCompanyId(companyId);
			courseAccountGroupParam.setSiteId(siteId);
			courseAccountGroupParam.setAdminId(adminId);
			courseAccountGroupParam.setIsAdmin(isAdmin);
			courseAccountGroupParam.setSerialNo(serialNo);
			courseAccountGroupParam.setTaskId(taskId);
			courseAccountGroupParam.setSubmitTime(submitTime);
			courseAccountGroupParam.setTaskName(taskName);
			courseAccountGroupParam.setIsAllData(isAllData);
			statisticsCourseClient.courseAccountDetails(courseAccountGroupParam);
			return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
		}




	/**
	 *  按照用户统计详情
	 * @param startDate
	 * @param endDate
	 * @param accountId
	 * @param kwd
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	@ApiOperation(value = "按用户统计详情", notes = "按用户统计详情", response = ReportStudyCourseAccountViewVo.class)
	@GetMapping("/account/group/view")
	public Response<ReportStudyCourseAccountViewVo> courseAccountGroupView(
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "用户Id", required = true) @RequestParam(name = "accountId", required = true) Long accountId,
			@ApiParam(value = "课程关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd,
			@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {

		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();

		CourseAccountGroupViewParam courseAccountGroupViewParam=new CourseAccountGroupViewParam();
		courseAccountGroupViewParam.setAccountId(accountId);
		courseAccountGroupViewParam.setKwd(kwd);
		courseAccountGroupViewParam.setStartDate(startDate);
		courseAccountGroupViewParam.setEndDate(endDate);
		courseAccountGroupViewParam.setCompanyId(companyId);
		courseAccountGroupViewParam.setSiteId(siteId);
		courseAccountGroupViewParam.setAdminId(adminId);
		courseAccountGroupViewParam.setIsAdmin(isAdmin);
		courseAccountGroupViewParam.setPageNo(pageNo);
		courseAccountGroupViewParam.setPageSize(pageSize);

		Page<ReportStudyCourseAccountViewVo> page=statisticsCourseClient.courseAccountGroupView(courseAccountGroupViewParam);

		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<ReportStudyCourseAccountViewVo> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}

		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", total);
		return Response.ok(list, pageMap);
	}




	/**
	 * 按照用户统计详情导出Excel
	 * @param request
	 * @param startDate
	 * @param endDate
	 * @param accountId
	 * @param kwd
	 * @return
	 */
	@ApiOperation(value = "按用户统计下载学习明细导出Excel", notes = "按用户统计下载学习明细导出Excel")
	@GetMapping("/account/group/view/export")
	public Response<String> courseAccountGroupViewExportExcel(HttpServletRequest request,
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "用户Id", required = true) @RequestParam(name = "accountId", required = true) Long accountId,
			@ApiParam(value = "课程关键字", required = false) @RequestParam(name = "kwd", required = false) String kwd,
		    @ApiParam(value = "是否包含所有学习数据", required = true) @RequestParam(name = "isAllData") boolean isAllData) {
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="在线课程-按用户统计-个人详情-下载学习明细-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();

		CourseAccountGroupViewParam courseAccountGroupViewParam=new CourseAccountGroupViewParam();
		courseAccountGroupViewParam.setAccountId(accountId);
		courseAccountGroupViewParam.setKwd(kwd);
		courseAccountGroupViewParam.setStartDate(startDate);
		courseAccountGroupViewParam.setEndDate(endDate);
		courseAccountGroupViewParam.setCompanyId(companyId);
		courseAccountGroupViewParam.setSiteId(siteId);
		courseAccountGroupViewParam.setAdminId(adminId);
		courseAccountGroupViewParam.setIsAdmin(isAdmin);
		courseAccountGroupViewParam.setSerialNo(serialNo);
		courseAccountGroupViewParam.setTaskId(taskId);
		courseAccountGroupViewParam.setSubmitTime(submitTime);
		courseAccountGroupViewParam.setTaskName(taskName);
		courseAccountGroupViewParam.setAllData(isAllData);
		statisticsCourseClient.courseAccountGroupViewExport(courseAccountGroupViewParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}












	/**
	 * 按照部门统计
	 * @param startDate
	 * @param endDate
	 * @param kwd
	 * @param pageSize
	 * @param pageNo
	 * @return
	 */
	@ApiOperation(value = "按部门统计", notes = "按部门统计", response = ReportStudyCourseOrgVo.class)
	@GetMapping("/org/group")
	public Response<ReportStudyCourseOrgVo> courseOrgGroup(
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "kwd", required = false) String kwd,
			@ApiParam(value = "每页条数，默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			@ApiParam(value = "当前页数", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {


		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();

		CourseOrgGroupParam courseOrgGroupParam=new CourseOrgGroupParam();
		courseOrgGroupParam.setKwd(kwd);
		courseOrgGroupParam.setStartDate(startDate);
		courseOrgGroupParam.setEndDate(endDate);
		courseOrgGroupParam.setCompanyId(companyId);
		courseOrgGroupParam.setSiteId(siteId);
		courseOrgGroupParam.setAdminId(adminId);
		courseOrgGroupParam.setIsAdmin(isAdmin);
		courseOrgGroupParam.setPageNo(pageNo);
		courseOrgGroupParam.setPageSize(pageSize);

		Page<ReportStudyCourseOrgVo> page = statisticsCourseClient.courseOrgGroup(courseOrgGroupParam);
		Map<String, Integer> pageMap = new HashMap<String, Integer>();
		Integer total=0;
		List<ReportStudyCourseOrgVo> list=null;
		if(page!=null) {
			total=page.getTotal();
			list=page.getRecords();
		}

		pageMap.put("pageNo", pageNo);
		pageMap.put("pageSize", pageSize);
		pageMap.put("pageTotal", total);
		return Response.ok(list, pageMap);
	}



	/**
	 * 按照部门统计下载
	 * @param request
	 * @param startDate
	 * @param endDate
	 * @param kwd
	 * @return
	 */
	@ApiOperation(value = "按部门统计导出Excel", notes = "按部门统计导出Excel")
	@GetMapping("/org/group/export")
	public Response<String> courseOrgGroupExportExcel(HttpServletRequest request,
			@ApiParam(value = "开始时间（yyyy-mm-dd）", required = true) @RequestParam(name = "startDate", required = true) String startDate,
			@ApiParam(value = "结束时间（yyyy-mm-dd）", required = true) @RequestParam(name = "endDate", required = true) String endDate,
			@ApiParam(value = "部门编码或名称", required = false) @RequestParam(name = "kwd", required = false) String kwd) {

		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo="USER-EXPORT-"+taskId;
		String taskName="在线课程-按部门统计-下载结果数据-"+taskId;
		RequestContext requestContext = ContextHolder.get();
		Long companyId = requestContext.getCompanyId();
		Long siteId =requestContext.getSiteId();
		Long adminId=requestContext.getAccountId();
		Boolean isAdmin=requestContext.isAdmin();

		CourseOrgGroupParam courseOrgGroupParam=new CourseOrgGroupParam();
		courseOrgGroupParam.setKwd(kwd);
		courseOrgGroupParam.setStartDate(startDate);
		courseOrgGroupParam.setEndDate(endDate);
		courseOrgGroupParam.setCompanyId(companyId);
		courseOrgGroupParam.setSiteId(siteId);
		courseOrgGroupParam.setAdminId(adminId);
		courseOrgGroupParam.setIsAdmin(isAdmin);
		courseOrgGroupParam.setSerialNo(serialNo);
		courseOrgGroupParam.setTaskId(taskId);
		courseOrgGroupParam.setSubmitTime(submitTime);
		courseOrgGroupParam.setTaskName(taskName);
		statisticsCourseClient.courseOrgGroupExport(courseOrgGroupParam);
		return Response.ok("任务编号："+serialNo+"。任务名称："+taskName);
	}


}
