package com.yizhi.application.report.customproject;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.custom.api.feign.ExperiencePoolReportClient;
import com.yizhi.custom.api.vo.custom.ExperiencePoolReportExportVo;
import com.yizhi.custom.api.vo.custom.ExperiencePoolReportVo;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Ding
 * @className ExperiencePoolReportController
 * @description TODO
 * @date 2018/11/29
 **/

@Api(tags = "经验池报表", description = "经验池报表")
@RestController
@RequestMapping("/manage/report/experiencePool")
public class ExperiencePoolReportController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExperiencePoolReportController.class);

    @Autowired
    private ExperiencePoolReportClient poolReportClient;

    @Autowired
    private PoolReportExport poolReportExport;

    @ApiOperation(value = "经验池报表获取列表", notes = "经验池报表获取列表", response = ExperiencePoolReportVo.class)
    @GetMapping("/list")
    public Response<ExperiencePoolReportVo> poolReportList(@ApiParam(value = "经验池名称", required = false) @RequestParam(name = "poolName", required = false) String poolName,
                                                           @ApiParam(value = "当前页数,默认第1页", required = false) @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                           @ApiParam(value = "每页条数,默认10", required = false) @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        try {
            RequestContext res = ContextHolder.get();
            return Response.ok(poolReportClient.poolReportList(poolName, pageNo, pageSize, res));
        } catch (Exception e) {
            LOGGER.error("获取列表出现错误", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池报表查看列表", notes = "经验池报表查看列表", response = ExperiencePoolReportExportVo.class)
    @GetMapping("/list/view")
    public Response<ExperiencePoolReportExportVo> viewPoolReportList(@ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId,
                                                                     @ApiParam(value = "用户关键字", required = false) @RequestParam(value = "accountName", required = false) String accountName,
                                                                     @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgName", required = false) String orgName,
                                                                     @ApiParam(value = "当前页,默认1", required = false) @RequestParam(value = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                                     @ApiParam(value = "每页条数,默认10", required = false) @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        try {
            Long siteId = ContextHolder.get().getSiteId();
            return Response.ok(poolReportClient.viewPoolReportList(poolId, accountName, orgName, pageNo, pageSize, null, null, null, siteId, ContextHolder.get()));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池报表查看下载", notes = "经验池报表查看下载")
    @GetMapping("/list/viewExport")
    public Response<String> viewPoolReportExport(@ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId,
                                                 @ApiParam(value = "经验池名称", required = true) @RequestParam(value = "poolName", required = true) String poolName,
                                                 @ApiParam(value = "用户关键字", required = false) @RequestParam(value = "accountName", required = false) String accountName,
                                                 @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgName", required = false) String orgName) {
        Map<String, Object> map = new HashMap<>();
        RequestContext res = ContextHolder.get();
        Long taskId = System.currentTimeMillis();
        String serialNo = "EXPERIENCE-VIEW-ACCOUNT-RANKINGS" + taskId.toString();
        String taskName = "经验-查看-按用户统计-经验值排名导出任务-" + taskId.toString();
        map.put("taskId", taskId);
        map.put("taskName", taskName);
        map.put("serialNo", serialNo);
        map.put("poolId", poolId);
        map.put("poolName", poolName);
        map.put("key", accountName);
        map.put("orgName", orgName);
        map.put("res", res);
        poolReportExport.execute(map, true);
        return Response.ok("导出成功," + " " + "编号:" + serialNo);
    }

    @ApiOperation(value = "经验池报表查看个人经验明细", notes = "经验池报表个人经验明细", response = ExperiencePoolReportExportVo.class)
    @GetMapping("/list/view/account/details")
    public Response<ExperiencePoolReportExportVo> viewAccountDetails(@ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId,
                                                                     @ApiParam(value = "用户id", required = false) @RequestParam(value = "accountId", required = true) Long accountId,
                                                                     @ApiParam(value = "状态:不传全部,1 经验值增加 2经验值减少", required = false) @RequestParam(value = "state", required = false) Integer state,
                                                                     @ApiParam(value = "当前页,默认1", required = false) @RequestParam(value = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                                     @ApiParam(value = "每页条数,默认10", required = false) @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        try {
            Page<ExperiencePoolReportExportVo> page = poolReportClient.viewAccountDetails(poolId, accountId, state, pageNo, pageSize);
            Map<String, Integer> pageMap = new HashMap<>(3);
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            if (null != page) {
                pageMap.put("total", page.getTotal());
            }
            return Response.ok(page, pageMap);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池报表查看个人经验明细下载", notes = "经验池报表个人经验明细下载")
    @GetMapping("/list/view/account/details/export")
    public Response<Object> viewAccountDetails(@ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId,
                                               @ApiParam(value = "用户id", required = false) @RequestParam(value = "accountId", required = true) Long accountId,
                                               @ApiParam(value = "状态:不传全部,1 经验值增加 2经验值减少", required = false) @RequestParam(value = "state", required = false) Integer state) {
        try {
            String serialNo = poolReportClient.viewAccountDetailsExport(poolId, accountId, state);
            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池报表导出所有人经验变更明细", notes = "经验池报表导出所有人经验变更明细")
    @GetMapping("/list/view/all/details/export")
    public Response<Object> viewAllDetailsExport(@ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId) {
        try {
            String serialNo = poolReportClient.viewAllDetailsExport(poolId);
            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池报表阶段明细列表", notes = "经验池报表阶段明细列表", response = ExperiencePoolReportExportVo.class)
    @GetMapping("/list/view/details/list")
    public Response<ExperiencePoolReportExportVo> viewStageDetailsList(@ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId,
                                                                       @ApiParam(value = "用户关键字", required = false) @RequestParam(value = "accountName", required = false) String accountName,
                                                                       @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgName", required = false) String orgName,
                                                                       @ApiParam(value = "开始时间", required = true) @RequestParam(value = "startTime", required = false) String startTime,
                                                                       @ApiParam(value = "结束时间", required = false) @RequestParam(value = "endTime", required = false) String endTime,
                                                                       @ApiParam(value = "当前页,默认1", required = false) @RequestParam(value = "pageNo", required = false, defaultValue = "1") Integer pageNo,
                                                                       @ApiParam(value = "每页条数,默认10", required = false) @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize) {
        try {
            Long siteId = ContextHolder.get().getSiteId();
            return Response.ok(poolReportClient.viewPoolReportList(poolId, accountName, orgName, pageNo, pageSize, 1, startTime, endTime, siteId, ContextHolder.get()));
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池报表导出阶段经验变更明细", notes = "经验池报表导出阶段经验变更明细")
    @GetMapping("/list/view/stage/details/export")
    public Response<Object> viewStageDetailsExport(@ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId,
                                                   @ApiParam(value = "开始时间", required = true) @RequestParam(value = "startTime", required = false) String startTime,
                                                   @ApiParam(value = "结束时间", required = false) @RequestParam(value = "endTime", required = false) String endTime,
                                                   @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgName", required = false) String orgName,
                                                   @ApiParam(value = "用户关键字", required = false) @RequestParam(value = "accountName", required = false) String accountName) {
        try {
            String serialNo = poolReportClient.viewStageDetailsExport(poolId, startTime, endTime, orgName, accountName);
            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "经验池报表导出阶段经验消耗明细", notes = "经验池报表导出阶段经验消耗明细")
    @GetMapping("/list/view/stage/purchase/details/export")
    public Response<Object> viewStagePurchaseDetailsExport(@ApiParam(value = "经验池id", required = true) @RequestParam(value = "poolId", required = true) Long poolId,
                                                           @ApiParam(value = "开始时间", required = true) @RequestParam(value = "startTime", required = false) String startTime,
                                                           @ApiParam(value = "结束时间", required = false) @RequestParam(value = "endTime", required = false) String endTime,
                                                           @ApiParam(value = "部门关键字", required = false) @RequestParam(value = "orgName", required = false) String orgName,
                                                           @ApiParam(value = "用户关键字", required = false) @RequestParam(value = "accountName", required = false) String accountName) {
        try {
            String serialNo = poolReportClient.viewStagePurchaseDetailsExport(poolId, startTime, endTime, orgName, accountName);
            return Response.ok("导出成功," + " " + "编号:" + serialNo);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }
}
