//package com.yizhi.application.vote.controller;
//
//import com.yizhi.application.context.ContextHolder;
//import com.yizhi.application.context.RequestContext;
//import com.yizhi.application.domain.TrVoteResults;
//import com.yizhi.application.domain.Vote;
//import com.yizhi.core.application.enums.FileType;
//import com.yizhi.application.feign.TpPlanActivityClient;
//import com.yizhi.application.feign.VoteClient;
//import com.yizhi.application.file.domain.Template;
//import com.yizhi.application.file.domain.TemplateColumn;
//import com.yizhi.application.file.exp.AbstractExporter;
//import com.yizhi.application.system.remote.AccountClient;
//import com.yizhi.application.task.TaskExecutor;
//import com.yizhi.application.util.constant.ReturnCode;
//import com.yizhi.application.util.domain.Response;
//import com.yizhi.application.util.page.PageInfo;
//import com.yizhi.application.vo.*;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import io.swagger.annotations.ApiParam;
//import org.apache.commons.lang3.StringUtils;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.util.CollectionUtils;
//import org.springframework.web.bind.annotation.*;
//
//import java.text.SimpleDateFormat;
//import java.util.ArrayList;
//import java.util.List;
//import java.util.Set;
//
///**
// * <p>
// * 投票 前端控制器
// * </p>
// *
// * @author lilingye
// * @since 2018-03-23
// */
//@Api(tags = "投票-投票接口")
//@RestController
//@RequestMapping("/manage/vote")
//public class VoteController {
//    private static final Logger LOGGER = LoggerFactory.getLogger(VoteController.class);
//
//    @Autowired
//    VoteClient voteClient;
//    @Autowired
//    AccountClient accountClient;
//
//    @Autowired
//    TaskExecutor taskExecutor;
//
//    @Autowired
//    private TpPlanActivityClient tpPlanActivityClient;
//
////    @Autowired
////    private SystemMessageClient systemMessageClient;
//
//    /**
//     * 发起投票
//     *
//     * @param voteOptionVO
//     */
//    @ApiOperation(value = "发起投票", notes = "发起投票", response = Vote.class)
//    @PostMapping("/insert")
//    public Response<Vote> addVote(@ApiParam("投票voteVO") @RequestBody VoteVO voteVO) {
//        // 从上下文中取出用户的相关信息
//        RequestContext context = ContextHolder.get();
//        voteVO.setCreateById(context.getAccountId());
//        voteVO.setCreateByName(context.getAccountName());
//        voteVO.setCompanyId(context.getCompanyId());
//        voteVO.setSiteId(context.getSiteId());
//        voteVO.setOrgId(context.getOrgId());
//        Vote vote = voteClient.addVote(voteVO);
//
//        if (vote != null) {
//            return Response.ok(vote);
//        } else {
//            return Response.fail();
//        }
//    }
//
//
//    /**
//     * 编辑投票
//     *
//     * @param voteOptionVO
//     */
//    @ResponseBody
//    @ApiOperation(value = "编辑投票", notes = "编辑发起的投票")
//    @PostMapping("/update")
//    public Response<Vote> updateVote(@ApiParam("投票voteVO") @RequestBody VoteVO voteVO) {
//        //获取用户信息
//        RequestContext context = ContextHolder.get();
//        voteVO.setUpdateById(context.getAccountId());
//        voteVO.setUpdateByName(context.getAccountName());
//        Vote vote = voteClient.updateVote(voteVO);
//
//        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm");
//        // 修改成功
//        if (vote != null) {
////            // 条用信息发送的接口
////            if (vote.getRemind() == 1) {
////
////                MessageReceiverVO messageReceiverVO;
////                List<Integer> sendTypes = null;
////                List<MessageReceiverVO> messageReceiverVOS = null;
////                MessageVO messageVO;
////                List<MessageVO> messageVOS = new ArrayList<MessageVO>();
////
////                String content = null;
////                //循环发送提醒
////                for (TrVoteRemindTimeVO trVoteRemindTimeVO : voteVO.getVoteRemindVO().getVoteRemindTimes()) {
////                    sendTypes = new ArrayList<Integer>();
////                    //循环发送提醒
////                    messageVO = new MessageVO();
////                    messageVO.setSubject(voteVO.getVoteName());             //消息标题
////                    messageVO.setMessageType(Integer.valueOf(MessageType.TP.getKey())); //消息类型(0自定义消息1学习计划2考试3调研4投票5报名6作业7签到8项目)
////                    messageVO.setTaskId(vote.getId());                                    //关联业务id,自定义消息为0
////                    content = voteVO.getVoteRemindVO().getContent();
////                    content = replaceContent(content, vote.getVoteName(), formatDate.format(vote.getStartTime()), formatDate.format(vote.getEndTime()));
////                    messageVO.setContext(content);          //消息内容
////                    Long type = voteVO.getVoteRemindVO().getType();
////                    //1开始前发送  2结束前发送  3自定义时间  (发生时间)
////                    messageVO.setAheadType(trVoteRemindTimeVO.getTriggerTime());        //提前时间类型
////                    if (type == 1) {
////                        messageVO.setHappenTime(vote.getStartTime());
////                    } else if (type == 2) {
////                        messageVO.setHappenTime(vote.getEndTime());
////                    } else if (type == 3) {
////                        messageVO.setHappenTime(trVoteRemindTimeVO.getCustomDate());
////                        messageVO.setAheadType(AheadType.ONTIME.getCode()); //时间是自定义时，设置默认值
////                    }
////
////                    //1全平台可见 2指定用户可见
////                    if (vote.getVisibleRange() == 1) {
////                        messageVO.setVisibleRange(Integer.valueOf(VisibleRange.ALL.getKey()));
////                    } else if (vote.getVisibleRange() == 2) {
////                        List<TrVoteParticipant> trVoteParticipantList = voteClient.getParticipant(vote.getId());
////                        messageReceiverVOS = new ArrayList<MessageReceiverVO>();
////                        for (TrVoteParticipant trVoteParticipant : trVoteParticipantList) {
////                            messageReceiverVO = new MessageReceiverVO();
////                            messageReceiverVO.setType(2);
////                            messageReceiverVO.setReceiverId(trVoteParticipant.getAccountId());
////                            messageReceiverVOS.add(messageReceiverVO);
////                        }
////                        messageVO.setReceiverVOs(messageReceiverVOS);       //关联人列表
////                    }
////                    //添加提醒消息类型
////                    if (voteVO.getVoteRemindVO().getType().intValue() == 0) {
////                        //站内
////                        sendTypes.add(Integer.parseInt(SendType.INSITE.getCode()));
////                    } else if (voteVO.getVoteRemindVO().getType().intValue() == 1) {
////                        // 邮件
////                        sendTypes.add(Integer.parseInt(SendType.MAIL.getCode()));
////                    } else {
////                        // 站内和邮件
////                        sendTypes.add(Integer.parseInt(SendType.MAIL.getCode()));
////                        sendTypes.add(Integer.parseInt(SendType.INSITE.getCode()));
////                    }
////                    messageVO.setSendTypes(sendTypes);
////                    messageVOS.add(messageVO);
////                }
////                try {
////                    LOGGER.info("调用考试提醒服务");
////                    systemMessageClient.add(messageVOS);
////                    LOGGER.info("调用考试提醒服务，成功");
////                } catch (Exception e) {
////                    LOGGER.info("调用考试提醒服务，失败");
////                    e.printStackTrace();
////                }
////            }
//            return Response.ok(vote);
//        } else {
//            return Response.fail();
//        }
//    }
//
//    /**
//     * 投票上架
//     *
//     * @param voteId 投票id
//     */
//    @ResponseBody
//    @ApiOperation(value = "投票上架", notes = "投票上架")
//    @PostMapping("/put/up")
//    public Response<String> upVote(
//            @ApiParam("投票id") @RequestBody VoteParamVO paramVO
//    ) {
//        RespVO res = voteClient.upVote(paramVO);
//        if ("".equals(res.getSubMsg())) {
//            return Response.ok(ReturnCode.SUCCESS);
//        } else {
//            return Response.fail("0", res.getSubMsg());
//        }
//
//    }
//
//    /**
//     * 投票下架
//     *
//     * @param voteId 投票id
//     */
//    @ApiOperation(value = "投票下架", notes = "投票下架")
//    @PostMapping("/put/down")
//    public Response<String> downVote(
//            @ApiParam("投票id") @RequestBody VoteParamVO paramVO
//    ) {
//
//        List<Long> ids = new ArrayList<Long>();
//        ids.add(paramVO.getId());
//        Set<String> tpNames = tpPlanActivityClient.checkBizIsExistInTpNames(ids);
//        String tpName = "";
//        boolean isUp = false;
//        if (!CollectionUtils.isEmpty(tpNames)) {
//            for (String s : tpNames) {
//                tpName = s;
//            }
//            isUp = true;
//        }
//        if (isUp) {
//            return Response.fail("10000", "已经关联到培训项目，培训项目名称:" + tpName + ",不可以下架。");
//        }
//
//        RespVO res = voteClient.downVote(paramVO);
//
//        if ("".equals(res.getSubMsg())) {
//            return Response.ok(ReturnCode.SUCCESS);
//        } else {
//            return Response.fail("0", res.getSubMsg());
//        }
//    }
//
//    /**
//     * 投票发布
//     *
//     * @param voteId 投票id
//     */
//    @ApiOperation(value = "投票发布", notes = "投票发布")
//    @PostMapping("/release ")
//    public Response<String> relesaseVote(@ApiParam("投票voteVO") @RequestBody VoteVO voteVO) {
//        Vote vote = voteClient.relesaseVote(voteVO);
//        if (vote != null) {
//            return Response.ok(ReturnCode.SUCCESS);
//        } else {
//            return  Response.fail(ReturnCode.SAVE_FAIL.getCode(),ReturnCode.SAVE_FAIL.getMsg());
//        }
//
//    }
//
//    /**
//     * 投票查看
//     *
//     * @param voteId 投票id
//     */
//    @ApiOperation(value = "查看", notes = "投票查看", response = VoteVO.class)
//    @GetMapping("/view")
//    public Response<VoteVO> viewVote(@ApiParam("投票id")
//                                     @RequestParam(required = true) String voteId
//    ) {
//        return Response.ok(voteClient.viewVote(voteId));
//    }
//
//    /**
//     * 清空投票
//     *
//     * @param voteId 投票id
//     */
//    @ApiOperation(value = "清空投票", notes = "清空投票")
//    @PostMapping("/zero")
//    public Response<String> zeroVote(@ApiParam("投票id")
//                                     @RequestBody VoteParamVO paramVO
//    ) {
//        int res = voteClient.zeroVote(paramVO);
//        if (res > 0) {
//            return Response.ok();
//        }
//        return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
//    }
//
//    /**
//     * 投票复制
//     *
//     * @param voteId 投票id
//     */
//    @ApiOperation(value = "投票复制", notes = "投票复制")
//    @PostMapping("/copy")
//    public Response<String> copyVote(@ApiParam("投票id")
//                                     @RequestBody VoteParamVO paramVO
//    ) {
//        int res = voteClient.copyVote(paramVO);
//        if (res > 0) {
//            return Response.ok(ReturnCode.SUCCESS);
//        } else {
//            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
//        }
//    }
//
//
//    /**
//     * 投票管理列表
//     *
//     * @param voteId 投票id
//     */
//    @ApiOperation(value = "投票管理列表", notes = "投票管理列表", response = PageVoteManageVO.class)
//    @GetMapping("/list")
//    public Response<PageVoteManageVO> listVote(
//            @ApiParam(name = "state", value = "状态，1草稿 2上架 3下架") @RequestParam(value = "state", required = false) Integer state,
//            @ApiParam(name = "voteName", value = "投票名称") @RequestParam(value = "voteName", required = false) String voteName,
//            @ApiParam(name = "trainingProId", value = "项目Id") @RequestParam(value = "trainingProId", required = false) String trainingProId,
//            @ApiParam(name = "currentTime", value = "当前时间") @RequestParam(value = "currentTime", required = false) String currentTime,
//            @ApiParam(name = "pageNo", value = "要跳转的页数") @RequestParam(value = "pageNo", defaultValue = "1", required = false) Integer pageNo,
//            @ApiParam(name = "pageSize", value = "每页条数，默认：10") @RequestParam(value = "pageSize", defaultValue = "10", required = false) Integer pageSize
//    ) {
//        RequestContext requestContext = ContextHolder.get();
//        Long siteId = requestContext.getSiteId();
//        Long orgId = requestContext.getOrgId();
//
//        PageVoteManageVO pageVoteManageVO = voteClient.listVote(state, voteName, trainingProId, siteId, orgId, currentTime, pageNo, pageSize);
//        return Response.ok(pageVoteManageVO);
//    }
//
//    /**
//     * 获取用户投票记录
//     *
//     * @param voteId    投票id
//     * @param accountId 用户id
//     * @param siteId    站点id
//     * @return
//     */
//    @ApiOperation(value = "获取用户投票记录", notes = "获取用户投票记录", response = PageAccountVoteVO.class)
//    @GetMapping("/account/detail")
//    public Response<PageAccountVoteVO> getVoteListById(
//            @ApiParam @RequestParam(required = true) Long voteId,
//            @ApiParam(name = "pageNo", value = "要跳转的页数", required = false) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
//            @ApiParam(name = "pageSize", value = "每页条数，默认：10", required = false) @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize
//
//    ) {
//
//        RequestContext context = ContextHolder.get();
//
//        PageAccountVoteVO pageAccountVoteVO = voteClient.getVoteListById(context.getAccountId(), context.getSiteId(), pageNo, pageSize);
//        return Response.ok(pageAccountVoteVO);
//    }
//
//    /**
//     * 获取所有用户投票记录
//     *
//     * @param voteId    投票id
//     * @param accountId 用户id
//     * @param siteId    站点id
//     * @return
//     */
//    @ApiOperation(value = "获取用所有户投票记录", notes = "获取所有用户投票记录", response = PageAccountVoteVO.class)
//    @GetMapping("/detail/list")
//    public Response<PageAccountVoteVO> getAccountVoteList(
//            @ApiParam @RequestParam(name = "voteId", required = true) Long voteId,
//            @ApiParam(name = "pageNo", value = "要跳转的页数", required = false) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
//            @ApiParam(name = "pageSize", value = "每页条数，默认：10", required = false) @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize
//
//    ) {
//
//        RequestContext context = ContextHolder.get();
//        PageAccountVoteVO pageAccountVoteVO =
//                voteClient.getAccountVoteList(voteId, context.getAccountId(), context.getSiteId(), pageNo, pageSize);
//        return Response.ok(pageAccountVoteVO);
//    }
//
//
//    /**
//     * 投票统计
//     *
//     * @param pageInfo 参数实体
//     */
//    @ApiOperation(value = "学员全部投票清单", notes = "学员全部投票清单", response = TrVoteResults.class)
//    @GetMapping("/account/list")
//    public Response<TrVoteResults> stuVoteList(
//            PageInfo pageInfo,
//            @ApiParam(value = "投票id") @RequestParam(value = "voteId") String voteId
//    ) {
//        return Response.ok(voteClient.stuVoteList(pageInfo, voteId));
//    }
//
//    @ApiOperation(value = "全量投票清单", notes = "全量导出清单")
//    @GetMapping("/account/export")
//    public void getVoteResults(
//            @ApiParam(value = "投票id") @RequestParam(name = "voteId", required = true) Long voteId
//    ) {
//        // 组装数据
//        List<TrVoteResults> trVoteResultsList = voteClient.getVoteResults(voteId);
//        List<Long> ids = new ArrayList<Long>();
//
//        for (TrVoteResults trVoteResults : trVoteResultsList) {
//            ids.add(trVoteResults.getAccountId());
//        }
//        List<AccountVO> accountVOs = accountClient.findByIds(ids);
//        List<VoteResultVO> voteResultVOs = new ArrayList<VoteResultVO>();
//        for (TrVoteResults trVoteResults : trVoteResultsList) {
//            VoteResultVO voteResultVO = new VoteResultVO();
//            voteResultVO.setOptionName(trVoteResults.getOptionName());
//            voteResultVO.setVoteTime(trVoteResults.getVoteTime());
//            for (AccountVO accountVO : accountVOs) {
//                if (accountVO.getId() == trVoteResults.getAccountId()) {
//                    voteResultVO.setName(accountVO.getName() + "/" + accountVO.getFullName());
//                    break;
//                }
//            }
//            voteResultVOs.add(voteResultVO);
//        }
//
//        Template template = new Template();
//
//        List<TemplateColumn> templateColumns = new ArrayList<TemplateColumn>();
//
//        TemplateColumn templateColumn1 = new TemplateColumn();
//        templateColumn1.setColumn("optionName");
//        templateColumn1.setColumnName("optionName");
//        templateColumns.add(templateColumn1);
//        TemplateColumn templateColumn2 = new TemplateColumn();
//        templateColumn2.setColumn("voteTime");
//        templateColumn2.setColumnName("voteTime");
//        templateColumns.add(templateColumn2);
//        TemplateColumn templateColumn3 = new TemplateColumn();
//        templateColumn3.setColumn("fullName");
//        templateColumn3.setColumnName("fullName");
//        templateColumns.add(templateColumn3);
//
//        template.setColumns(templateColumns);
//        template.setStartLine(1);
//        template.setFileType("XLS");
//        template.setFileName("学员投票清单");
//
//        //导出数据
//        AbstractExporter<VoteResultVO> ab = AbstractExporter.build(FileType.XLS, template, voteResultVOs);
////		 ab.handle();
//        taskExecutor.asynExecute(ab);
//
//    }
//
//    /**
//     * 删除投票选项
//     *
//     * @param voteParamVO
//     * @return
//     */
//    @ApiOperation(value = "删除投票", notes = "删除投票", response = TrVoteResults.class)
//    @PostMapping("/delete")
//    public Response<String> deleteVote(
//            @ApiParam(value = "投票id") @RequestBody VoteParamVO voteParamVO
//    ) {
//        Boolean res = voteClient.deleteVote(voteParamVO);
//        if (res) {
//            return Response.ok(ReturnCode.SUCCESS);
//        } else {
//            return Response.ok(ReturnCode.DELETE_FAIL);
//        }
//    }
//
//    /**
//     * 提醒关键字替换
//     *
//     * @param value
//     * @param exam
//     * @return
//     */
//    private String replaceContent(String value, String name, String startTime, String endTime) {
//        if (!StringUtils.isBlank(value)) {
//            value = value.replace("{投票名称}", name);
//            value = value.replace("{开始时间}", startTime);
//            value = value.replace("{结束时间}", endTime);
//        }
//
//        return value;
//    }
//}
//
