package com.yizhi.application.wechat;

import com.yizhi.util.application.domain.Response;
import com.yizhi.wechat.application.feign.WeiXinClient;
import com.yizhi.wechat.application.vo.wechat.ResponseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 微信系统用户的信息
 * @author  lilingye
 * @Date 2018-7-26 11:12:59
 */
@Api(tags = "微信管理端接口")
@RestController
@RequestMapping("/manage/wechat")
public class UserInfoController {
    @Autowired
    WeiXinClient weiXinClient;
    @ApiOperation(value = "解绑用户", notes = "解绑用户")
    @PostMapping(value = "/unbinduser")
    public Response<String> unbindUser(@ApiParam("用户id列表") @RequestBody List<Long> accountIds){
        ResponseVO responseVO = new ResponseVO();
        try {
             responseVO = weiXinClient.delRelation(accountIds);
        } catch (Exception e) {
            e.printStackTrace();
        }

        if ("1".equals(responseVO.getCode())) {
            return Response.ok(responseVO.getCode(),responseVO.getMsg());
        }else {
            return Response.fail(responseVO.getCode(),responseVO.getMsg());
        }
    }
}
