package com.yizhi.application.assignment.controller;

import java.util.*;
import javax.servlet.http.HttpServletRequest;

import com.alibaba.fastjson.JSON;
import com.yizhi.application.accountUtil.AuthorizeQueryAccount;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.application.util.TaskSendMessage;
import com.yizhi.assignment.application.feign.AssignmentClient;
import com.yizhi.assignment.application.vo.*;
import com.yizhi.assignment.application.vo.apivo.ApiAssignmentAnswerCheckVO;
import com.yizhi.assignment.application.vo.entity.AssignmentAnswerFile;
import com.yizhi.assignment.application.vo.entity.AssignmentAuditor;
import com.yizhi.assignment.application.vo.entity.AssignmentStudent;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.point.application.feign.PointRedisFeignClients;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.system.remote.OrganizationClient;
import com.yizhi.system.application.vo.AccountPageVO;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.OrgVO;
import com.yizhi.training.application.feign.TpPlanActivityClient;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.page.PageInfo;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.assignment.vo.manage.RelationStudentListVo;
import com.yizhi.application.assignment.vo.manage.RelationStudentVo;
import com.yizhi.application.point.constant.MQqueuesEnum;
import com.yizhi.application.point.constant.PointEventEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(tags = "管理端-作业接口")
@RestController
@RequestMapping("/manage/assignment")
public class ManageAssignmentController {

    private static final Logger LOG = LoggerFactory.getLogger(ManageAssignmentController.class);
    @Autowired
    private AssignmentClient assignmentClient;
    @Autowired
    private AccountClient accountClient;
    @Autowired
    private OrganizationClient organizationClient;
    @Autowired
    private AssignmentUnsubmittedExport assignmentExport;
    @Autowired
    private AssignmentReadResultExport assignmentReadResultExport;
   /* @Autowired
    private AmqpTemplate amqpTemplate;*/
    @Autowired
    private PointRedisFeignClients pointRedisFeignClients;
    @Autowired
    private AssignmentDownloadAnswerExport assignmentDownloadAnswerExport;
    @Autowired
    private TpPlanActivityClient tpPlanActivityClient;
    @Autowired
    private AuthorizeQueryAccount queryAccount;
    @Autowired
    private TaskSendMessage taskSendMessage;


    @GetMapping("/setid")
    public Response<Long> setId() {
        try {
            Long id = assignmentClient.setId();
            if (id != null) {
                return Response.ok(id);
            } else {
                return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "作业新建接口", notes = "新建作业保存")
    @PostMapping("/save")
    public Response<Boolean> save(@RequestBody AssignmentSaveParamVo assignmentSaveParamVo) {
        try {
//            if (assignmentSaveParamVo.getEnableTask() == null) {
//                return Response.fail("enableTask不可为空！！！");
//            }
            assignmentSaveParamVo.setAccountId(ContextHolder.get().getAccountId());
            assignmentSaveParamVo.setAccountName(ContextHolder.get().getAccountName());
            assignmentSaveParamVo.setCompanyId(ContextHolder.get().getCompanyId());
            assignmentSaveParamVo.setSiteId(ContextHolder.get().getSiteId());
            assignmentSaveParamVo.setOrgId(ContextHolder.get().getOrgId());
            if (assignmentSaveParamVo.getType() == 2 && assignmentSaveParamVo.getListGrade().size() <= 0) {
                return Response.fail(ReturnCode.PARAM_INVALID);
            }
            Boolean x = assignmentClient.save(assignmentSaveParamVo);
            if (x) {
                return Response.ok(ReturnCode.SUCCESS);
            } else {
                return Response.ok(ReturnCode.SAVE_FAIL);
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "作业列表接口", notes = "分页查询作业列表", response = AssignmentListVO.class)
    @GetMapping("/list")
    public Response<AssignmentListVO> list(@RequestParam(value = "currentTime", required = false) String currentTime,
                                           AssignmentListVoTo assignmentListVoTo) {
        try {
            if (assignmentListVoTo.getPageNo() == null) {
                assignmentListVoTo.setPageNo(1);
            }
            if (assignmentListVoTo.getPageSize() == null) {
                assignmentListVoTo.setPageSize(20);
            }
            Page<AssignmentListVO> page = assignmentClient.list(currentTime, assignmentListVoTo);
            List<AssignmentListVO> list2 = new ArrayList<AssignmentListVO>();
            if (page != null) {
                list2 = page.getRecords();
            }
            Map<String, Integer> map = new HashMap<String, Integer>();
            map.put("current", assignmentListVoTo.getPageNo());
            map.put("size", assignmentListVoTo.getPageSize());
            map.put("total", page.getTotal());
            Pair<List<AssignmentListVO>, Map<String, Integer>> pair = new MutablePair<List<AssignmentListVO>, Map<String, Integer>>(list2, map);
            return Response.ok(pair);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "作业删除接口", notes = "作业删除")
    @PostMapping("/delete")
    public Response<String> delete(
            @ApiParam(name = "AssignmentDeleteVO", value = "作业删除入参对象", required = true) @RequestBody AssignmentDeleteVO assignmentDelete) {
        try {
            assignmentDelete.setAccountId(ContextHolder.get().getAccountId());
            assignmentDelete.setAccountName(ContextHolder.get().getAccountName());

            List<Long> listId = new ArrayList<Long>();
            listId.add(assignmentDelete.getAssignmentId());
            Set<String> setName = tpPlanActivityClient.checkBizIsExistInTpNames(listId);
            String name = null;
            for (String str : setName) {
                name = str;
            }

            if (name != null) {
                return Response.fail("10000", InternationalEnums.MANAGEASSIGNMENTCONTROLLER1.getCode() + name + InternationalEnums.MANAGEASSIGNMENTCONTROLLER6.getCode());
            }

            Boolean x = assignmentClient.delete(assignmentDelete);
            if (x) {
                return Response.ok(ReturnCode.SUCCESS);
            } else {
                return Response.fail(ReturnCode.DELETE_FAIL.getCode(),ReturnCode.DELETE_FAIL.getMsg());
            }


        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "下载学生作业", notes = "学生作业id列表", response = AssignmentAnswerFile.class)
    @GetMapping("/download/batch")
    public Response<List<List<AssignmentAnswerFile>>> getAssignmentAnswerList(
            @ApiParam(name = "ids", value = "学生的作业答案id", required = true) @RequestParam(name = "ids", required = true) List<Long> ids) {
        try {
            List<List<AssignmentAnswerFile>> list = assignmentClient.getAssignmentAnswerList(ids);
            if (CollectionUtils.isEmpty(list)) {
                return Response.ok(list);
            } else {
                return Response.ok(ReturnCode.RESOURCE_NOT_FOUND);
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "获取单个作业信息", notes = "单个作业信息", response = ApiAssignmentAnswerCheckVO.class)
    @PostMapping("/marking/select")
    public Response<ApiAssignmentAnswerCheckVO> getAssignmentAnswer(
            @ApiParam(name = "AssignmentAnswerMarkingSelectVO", value = "获取单个学生作业信息入参", required = true) @RequestBody AssignmentAnswerMarkingSelectVO assignmentAnswerMarkingSelect) {
        try {
            List<Long> accountIds = accountClient.getAccountIds();
            assignmentAnswerMarkingSelect.setAccountIds(accountIds);
            ApiAssignmentAnswerCheckVO apiAssignmentAnswerCheckVO = assignmentClient.getAssignmentAnswer(assignmentAnswerMarkingSelect);
            if (apiAssignmentAnswerCheckVO != null) {
                return Response.ok(apiAssignmentAnswerCheckVO);
            } else {
                return Response.ok(ReturnCode.RESOURCE_NOT_FOUND);
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "根据老师布置作业id，找到所有的学员作业", notes = "学生作业列表", response = AssignmentReadListVO.class)
    @GetMapping(value = "/answer/list")
    public Response<AssignmentReadListVO> assignmentAnswerList(
            @ApiParam(name = "assignmentId", value = "老师布置作业的id", required = true) @RequestParam(name = "assignmentId", required = true) Long assignmentId,
            @ApiParam(name = "state", value = "批阅状态（1:待阅，2：已阅,不传则为所有）", required = false) @RequestParam(name = "state", required = false) Integer state,
            @ApiParam(name = "name", value = "用户名/姓名/标签") @RequestParam(name = "name", required = false) String name,
            @ApiParam(name = "department", value = "部门关键字", required = false) @RequestParam(name = "department", required = false) String department,
            @ApiParam(name = "type", value = "1.提交时间；2 用户名", required = false) @RequestParam(name = "type", required = false,defaultValue = "1") Integer type,
            @ApiParam(name = "pageNo", value = "要跳转的页数", required = false) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数，默认：10", required = false) @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        try {
//            RequestContext context = ContextHolder.get();
//            LOG.info("当前用户上下文信息：{}",JSON.toJSON(context));
            // 获取管辖区内用户的ids
//            if (!context.isAdmin()) {
            List<Long> accountIds = accountClient.getAccountIds();
                LOG.info("当前管辖区用户的id：{}", JSON.toJSON(accountIds));
//            }

            Page<AssignmentReadListVO> page = null;
//                    assignmentClient.assignmentAnswerList(assignmentId,  state,
//                    name,department,type, pageNo, pageSize);
            AnswerListVo answerListVo = new AnswerListVo();
            answerListVo.setAssignmentId(assignmentId);
            answerListVo.setState(state);
            answerListVo.setName(name);
            answerListVo.setKeywords(department);
            answerListVo.setType(type);
            answerListVo.setPageNo(pageNo);
            answerListVo.setPageSize(pageSize);
            answerListVo.setAccountIds(accountIds);

            page = assignmentClient.manageAssignmentAnswerList(answerListVo);
            List<AssignmentReadListVO> list = null;
            if (page != null) {
                list = page.getRecords();
            }
            Map<String, Integer> map = new HashMap<String, Integer>();
            map.put("current", pageNo);
            map.put("size", pageSize);
            map.put("total", page.getTotal());
            Pair<List<AssignmentReadListVO>, Map<String, Integer>> pair = new MutablePair<List<AssignmentReadListVO>, Map<String, Integer>>(list, map);
            return Response.ok(pair);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @GetMapping("/content/find")
    @ApiOperation(value = "查看老师布置得作业的主键id查看作业具体内容", notes = "查看作业内容", response = AssignmentSelectVo.class)
    public Response<AssignmentSelectVo> query(
            @ApiParam(name = "assignmentId", value = "作业id主键", required = true) @RequestParam Long assignmentId) {
        try {
            AssignmentSelectVo assignmentContent = assignmentClient.query(assignmentId);
            return Response.ok(assignmentContent);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "学员名单添加学员接口", notes = "添加学员", response = Response.class)
    @PostMapping("/student/add")
    public Response<String> insert(@RequestBody ListStudent listStudent) {
        try {
            listStudent.setAccountId(ContextHolder.get().getAccountId());
            listStudent.setAccountName(ContextHolder.get().getAccountName());
            Boolean x = assignmentClient.insert(listStudent);
            if (x) {
                return Response.ok(ReturnCode.SUCCESS);
            } else {
                return Response.ok(ReturnCode.SAVE_FAIL);
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "查看已关联的学员名单", notes = "已关联的学员名单")
    @GetMapping("/student/relation")
    public Response<RelationStudentListVo> studentRelation(
            @ApiParam(name = "assignmentId", value = "作业id主键", required = true) @RequestParam(name = "assignmentId", required = true) Long assignmentId) {
        try {
            List<AssignmentStudent> ranges = assignmentClient.studentRelation(assignmentId); // AssignmentStudent的所有信息

            RelationStudentListVo relationStudentListVo = new RelationStudentListVo();
            if (!CollectionUtils.isEmpty(ranges)) {
                List<Long> accountIds = new ArrayList<>(ranges.size());
                List<Long> orgIds = new ArrayList<>(ranges.size());
                ranges.forEach(a -> {
                    if (a.getType().equals(1)) {
                        orgIds.add(a.getAccountId());
                    } else {
                        accountIds.add(a.getAccountId());
                    }
                });
                List<RelationStudentVo> listRelationAccount = new ArrayList<RelationStudentVo>(ranges.size());
                Map<Long, AccountVO> map = queryAccount.queryAccountByIds(accountIds);
                Map<Long, OrgVO> orgMap = queryAccount.queryOrgByIds(orgIds);
                ranges.forEach(a -> {
                    RelationStudentVo relationStudentVo = new RelationStudentVo();
                    if (null != map) {
                        AccountVO accountVO = map.get(a.getAccountId());
                        if (null != accountVO && a.getType() == 2) {
                            relationStudentVo.setWorkNum(accountVO.getWorkNum());
                            relationStudentVo.setFullName(accountVO.getFullName());
                            relationStudentVo.setName(accountVO.getName());
                        }
                    }
                    if (null != orgMap) {
                        OrgVO orgVO = orgMap.get(a.getAccountId());
                        if (null != orgVO && a.getType() == 1) {
                            relationStudentVo.setName(orgVO.getName());
                        }
                    }
                    relationStudentVo.setId(a.getAccountId());
                    relationStudentVo.setType(a.getType());
                    listRelationAccount.add(relationStudentVo);
                });
                relationStudentListVo.setAssignmentId(assignmentId);
                relationStudentListVo.setListAccount(listRelationAccount);
            }
            return Response.ok(relationStudentListVo);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "上架下架", notes = "上架下架")
    @PostMapping("/status/update")
    public Response<String> update(
            @ApiParam(name = "assignmentUpAndDown", value = "上架下架", required = true) @RequestBody AssignmentUpAndDownVO assignmentUpAndDown) {
        try {

            List<Long> listId = new ArrayList<Long>();
            listId.add(assignmentUpAndDown.getId());
            Set<String> setName = tpPlanActivityClient.checkBizIsExistInTpNames(listId);
            String name = null;
            for (String str : setName) {
                name = str;
            }

            if (name != null && assignmentUpAndDown != null && assignmentUpAndDown.getStatus() == 0) {
                return Response.fail("10000", InternationalEnums.MANAGEASSIGNMENTCONTROLLER1.getCode() + name + InternationalEnums.MANAGEASSIGNMENTCONTROLLER6.getCode());
            }
            assignmentUpAndDown.setAccountId(ContextHolder.get().getAccountId());
            assignmentUpAndDown.setAccountName(ContextHolder.get().getAccountName());
            //删除和  上架/下架/草稿互相转换
            Boolean x = assignmentClient.update(assignmentUpAndDown);
            if (x) {

                return Response.ok(ReturnCode.SUCCESS);
            } else {
                return Response.fail(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());
            }

        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "作业批阅接口", notes = "作业批阅保存")
    @PostMapping("/marking/save")
    public Response<String> readSave(@RequestBody AssignmentAnswerContentVO assignmentAnswerContentVO) {
        try {
            assignmentAnswerContentVO.setAccountId(ContextHolder.get().getAccountId());
            assignmentAnswerContentVO.setAccountName(ContextHolder.get().getAccountName());
            List<AssignmentAnswerFile> list = assignmentAnswerContentVO.getListFeedBackFiles();
            if (list != null && list.size() > 5) {
                return Response.fail(InternationalEnums.MANAGEASSIGNMENTCONTROLLER2.getCode());
            }
            assignmentAnswerContentVO.setListFeedBackFiles(list);
            PointParamVO pointParamVO = assignmentClient.readSave(assignmentAnswerContentVO);

            try {
                /**
                 * 向积分池发放积分
                 */
                if (pointParamVO != null) {
                    pointParamVO.setEventName(PointEventEnum.POINTASSIGNMENT.getKey());
                    pointParamVO.setActivityType("作业通过积分发放");                    //事件类型
                    pointParamVO.setActivitySource("作业");                            //学习活动来源
                    pointParamVO.setReleaseCondition("范围发放");                    //发放条件
                    pointParamVO.setReleaseRules("按照范围取积分");                    //发放规则
                    pointParamVO.setScore(assignmentAnswerContentVO.getScore());

                    com.yizhi.point.application.vo.PointParamVO vo = new com.yizhi.point.application.vo.PointParamVO();
                    BeanUtils.copyProperties(pointParamVO,vo);
                    String sitePointId = pointRedisFeignClients.addPointRedis(vo);    //调用积分接口添加积分
                    if (null != sitePointId) {
                        //amqpTemplate.convertAndSend(MQqueuesEnum.ASSIGNMENT.getKey(), sitePointId);    //发送积分获取消息
                    }
                    String sitePointId1 = pointRedisFeignClients.addPointRedis(vo);
                    if (null!=sitePointId1) {
				    	 //amqpTemplate.convertAndSend(MQqueuesEnum.EXPERIENCASSIGNMENT.getKey(),sitePointId);	//发送经验获取消息
					}
                }
            } catch (Exception e) {
                LOG.error("批阅作业积分发放失败：", e);
            }
            return Response.ok(ReturnCode.SUCCESS);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.BIZ_FAIL.getCode(),ReturnCode.BIZ_FAIL.getMsg());
        }
    }

    @ApiOperation(value = "作业评阅人来源", notes = "作业评阅人来源")
    @GetMapping("/get/all/auditor")
    public Response<String> getAllAuditor(
            @ApiParam(name = "name", value = "用户名姓名", required = false) @RequestParam(name = "name", required = false) String name,
            @ApiParam(name = "pageNo", value = "要跳转的页数", required = false) @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数，默认：10", required = false) @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        try {
            AccountPageVO accountPageVO = new AccountPageVO();
            if (name != null) {
                accountPageVO.setName(name);
            }
            accountPageVO.setPageNo(pageNo);
            accountPageVO.setPageSize(pageSize);
            // 站点下所有的管理员
            PageInfo<AccountVO> pageInfo = accountClient.managerList(accountPageVO);
            if (pageInfo != null) {
                return Response.ok(pageInfo);
            } else {
                return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "设置作业评阅人", notes = "设置作业评阅人")
    @PostMapping("/set/auditor")
    public Response<String> setAuditor(@RequestBody ListAuditor listAuditor) {
        try {
            listAuditor.setContextHolder(ContextHolder.get());
            Boolean x = assignmentClient.auditorInsert(listAuditor);
            if (x) {
                return Response.ok(ReturnCode.SUCCESS);
            } else {
                return  Response.fail(ReturnCode.SAVE_FAIL.getCode(),ReturnCode.SAVE_FAIL.getMsg());
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "查看已选的作业评阅人", notes = "查看作业评阅人")
    @GetMapping("/get/auditor")
    public Response<List<AssignmentAuditor>> getAuditor(
            @ApiParam(name = "assignmentId", value = "作业id主键", required = true) @RequestParam(name = "assignmentId", required = true) Long assignmentId) {
        try {
            List<Long> list = assignmentClient.auditorRelation(assignmentId);
            List<AssignmentAuditor> listAuditor = new ArrayList<>();
            if (list != null) {
                for (int i = 0; i < list.size(); i++) {
                    AssignmentAuditor assignmentAuditor = new AssignmentAuditor();
                    Long accountId = list.get(i);
                    assignmentAuditor.setAccountId(accountId);
                    AccountVO accountVO = accountClient.findById(accountId);
                    assignmentAuditor.setCreateByName(accountVO.getName());
                    listAuditor.add(assignmentAuditor);
                }
                return Response.ok(listAuditor);
            } else {
                return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
            }
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "导出作业批阅结果", notes = "导出作业批阅结果")
    @PostMapping("/export/suggetion/get")
    public Response<String> exportSuggetionExcel(HttpServletRequest request, @RequestBody DownloadAnswerVO vo) {

        Date submitTime = new Date();
        Long taskId = submitTime.getTime();
        String serialNo = "USER-EXPORT-" + taskId;
        String taskName = "导出作业批阅结果-" + taskId;
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("assignmentId", vo.getAssignmentId());
        map.put("answerIds", vo.getAnswerIds());
        map.put("accountId", ContextHolder.get().getAccountId());
        map.put("siteId", ContextHolder.get().getSiteId());
        map.put("companyId", ContextHolder.get().getCompanyId());
        map.put("serialNo", serialNo);
        map.put("taskId", taskId);
        map.put("submitTime", submitTime);
        map.put("taskName", taskName);
        assignmentReadResultExport.execute(map, true);
        return Response.ok("任务编号：" + serialNo + "。任务名称：" + taskName);
    }

    @ApiOperation(value = "导出未提交作业的名单", notes = "导出未提交作业的名单")
    @GetMapping("/export/unsubmit/get")
    public Response<String> exportExcel(HttpServletRequest request,
                                        @ApiParam("作业的Id") @RequestParam(name = "assignmentId", required = true) Long assignmentId) {
        Date submitTime = new Date();
        Long taskId = submitTime.getTime();
        String serialNo = "USER-EXPORT-" + taskId;
        String taskName = "导出作业未提交名单-" + taskId;
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("assignmentId", assignmentId);
        map.put("accountId", ContextHolder.get().getAccountId());
        map.put("siteId", ContextHolder.get().getSiteId());
        map.put("companyId", ContextHolder.get().getCompanyId());
        map.put("serialNo", serialNo);
        map.put("taskId", taskId);
        map.put("submitTime", submitTime);
        map.put("taskName", taskName);
        assignmentExport.execute(map, true);
        return Response.ok("任务编号：" + serialNo + "。任务名称：" + taskName);
    }

    @ApiOperation(value = "批量下载作业", notes = "批量下载作业")
    @PostMapping("/export/downloadAnswer/get")
    public Response<String> exportAssignment(HttpServletRequest request, @RequestBody DownloadAnswerVO vo) {
        Date submitTime = new Date();
        Long taskId = submitTime.getTime();
        String serialNo = "USER-EXPORT-" + taskId;
        String taskName = "批量下载作业-" + taskId;
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("vo", vo);
        map.put("accountId", ContextHolder.get().getAccountId());
        map.put("siteId", ContextHolder.get().getSiteId());
        map.put("companyId", ContextHolder.get().getCompanyId());
        map.put("serialNo", serialNo);
        map.put("taskId", taskId);
        map.put("submitTime", submitTime);
        map.put("taskName", taskName);
        assignmentDownloadAnswerExport.execute(map, true);
        return Response.ok("任务编号：" + serialNo + "。任务名称：" + taskName);
    }

}
