package com.yizhi.application.course.controller;

import com.alibaba.fastjson.JSON;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.course.application.feign.CourseBathEditClient;
import com.yizhi.course.application.vo.BathEditCourseVo;
import com.yizhi.course.application.vo.CourseAccountVO;
import com.yizhi.course.application.vo.CourseShelvesVo;
import com.yizhi.course.application.vo.CourseVo;
import com.yizhi.course.application.vo.domain.CourseEntityVo;
import com.yizhi.training.application.feign.TpPlanActivityClient;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Api(tags = "管理端-课程批量修改", description = "课程管理端批量编辑接口")
@RestController
@RequestMapping("/manage/course")
public class CourseBathEditController {

    private static final Logger LOG = LoggerFactory.getLogger(CourseBathEditController.class);

    @Autowired
    CourseBathEditClient courseBathEditClient;

    @Autowired
    TpPlanActivityClient tpPlanActivityClient;

    @ApiOperation(value = "针对课程的分类做批量修改操作", notes = "课程分类批量修改")
    @PostMapping("/bath/edit/classify")
    public Response courseClassifyEdit(@RequestBody BathEditCourseVo vo){
        Long accountId = ContextHolder.get().getAccountId();
        vo.setUpdateByaccountId(accountId);
        /*List<CourseAccountVO> tmp = new ArrayList<>();
        vo.setCourseAccounts(tmp);*/
        List<Long> editObject = vo.getEditObject();
        CourseVo courseVo = vo.getEditFields();
        Long classifyId = courseVo.getClassifyId();
        LOG.info("修改分类的请求参数={}", JSON.toJSONString(vo));
        if(Objects.isNull(classifyId)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER1.getCode());
        }
        if(CollectionUtils.isEmpty(editObject)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER2.getCode());
        }
        boolean ret = courseBathEditClient.courseClassifyEdit(vo);
        if(ret){
            return Response.ok();
        }else {
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER3.getCode());
        }
    }

    @PostMapping("/bath/edit/shelves/check") // 课程下架检查
    @ApiOperation(value = "批量下架确认前的检查，提示哪些课程已经被项目关联", notes = "批量下架检查提示")
    public Response shelvesCheck(@RequestBody BathEditCourseVo vo){
        List<Long> editObject = vo.getEditObject();
        CourseVo courseVo = vo.getEditFields();
        Integer shelves = courseVo.getShelves();
        if(Objects.isNull(shelves)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER4.getCode());
        }
        List<Long> ignoreCourses = editObject;
        if(shelves.intValue()==0){
            ignoreCourses = tpPlanActivityClient.checkBizIsExistInTp(editObject);
        }
        //List<Long> list = editObject.stream().map(item->item.getId()).collect(Collectors.toList());

        LOG.info("批量下架检查的请求参数={}，下架关联的课程ids={}", JSON.toJSONString(vo),JSON.toJSONString(ignoreCourses));
        List<Long> dataIds = getResponse(editObject, ignoreCourses);
        if(CollectionUtils.isEmpty(dataIds)){
            return Response.ok();
        }else{
            CourseShelvesVo vo1 = new CourseShelvesVo();
            vo1.setShelves(shelves);
            vo1.setBindCourseIds(ignoreCourses);
            vo1.setCourseIds(editObject);
            return Response.ok(courseBathEditClient.courseShelvesCheck(vo1));
        }
    }

    @PostMapping("/bath/edit/shelves")
    @ApiOperation(value = "批量上下架操作", notes = "批量上下架操作")
    public Response courseShelvesEdit(@RequestBody BathEditCourseVo vo){
        Long accountId = ContextHolder.get().getAccountId();
        vo.setUpdateByaccountId(accountId);

        List<Long> editObject = vo.getEditObject();
        CourseVo courseVo = vo.getEditFields();
        Integer shelves = courseVo.getShelves();
        if(Objects.isNull(shelves)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER5.getCode());
        }
        if(CollectionUtils.isEmpty(editObject)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER8.getCode());
        }
        if(Objects.nonNull(shelves) && shelves.intValue()==0){
            //List<Long> list = editObject.stream().map(item->item.getId()).collect(Collectors.toList());
            List<Long> ignoreCourses = tpPlanActivityClient.checkBizIsExistInTp(editObject);
            if(!CollectionUtils.isEmpty(ignoreCourses)){
                List<Long> upData = new ArrayList<>();
                for(Long courseItem : editObject){
                    if(!ignoreCourses.contains(courseItem)){
                        upData.add(courseItem);
                    }
                }
                // todo 讲师库关联排除
                if(CollectionUtils.isEmpty(upData)){
                    return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER9.getCode());
                }
                vo.setEditObject(upData);
            }
        }else if(Objects.nonNull(shelves) && shelves.intValue()==1){
            CourseShelvesVo vo1 = new CourseShelvesVo();
            vo1.setShelves(1);
            vo1.setCourseIds(editObject);
            List<Map<String, Object>> dataExtis = courseBathEditClient.courseShelvesCheck(vo1);
            LOG.info("排除的数据{}",JSON.toJSONString(dataExtis));
            if(!CollectionUtils.isEmpty(dataExtis)){
                for(Map<String, Object> item : dataExtis){
                    Long extisId = Long.valueOf(item.get("id").toString());
                    if(editObject.contains(extisId)){
                        editObject.remove(extisId);
                    }
                }
                LOG.info("组装，排除的数据{}",JSON.toJSONString(editObject));
                if(CollectionUtils.isEmpty(editObject)){
                    return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER9.getCode());
                }
                vo.setEditObject(editObject);
            }
        }
        //LOG.info("批量下架的请求参数={}", JSON.toJSONString(vo));
        boolean ret = courseBathEditClient.courseShelvesEdit(vo);
        if(ret){
            return Response.ok();
        }else {
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER9.getCode());
        }
    }

    @PostMapping("/bath/edit/strategy/check")
    @ApiOperation(value = "批量修改策略确认前的检查，提示哪些课程目前是上架状态", notes = "批量策略修改提示")
    public Response courseStrategyCheck(@RequestBody BathEditCourseVo vo){
        List<Long> editObject = vo.getEditObject();
        if(CollectionUtils.isEmpty(editObject)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER8.getCode());
        }

        //List<Long> ids = editObject.stream().map(item->item.getId()).collect(Collectors.toList());
        List<CourseEntityVo> ignoreCourses = courseBathEditClient.courseStrategyCheck(editObject);
        List<Long> ignoreCourseIds = null;
        if(!CollectionUtils.isEmpty(ignoreCourses)){
            ignoreCourseIds = ignoreCourses.stream().map(id->id.getId()).collect(Collectors.toList());
        }
        // todo  讲师库关联查询
        LOG.info("课程已经上架的的ids={}",JSON.toJSONString(ignoreCourseIds));
        //return getResponse(editObject, ignoreCourseIds);
        List<Long> dataIds = getResponse(editObject, ignoreCourseIds);
        if(CollectionUtils.isEmpty(dataIds)){
            return Response.ok();
        }else{
            CourseShelvesVo courseShelvesVo = new CourseShelvesVo();
            courseShelvesVo.setBindCourseIds(dataIds);
            courseShelvesVo.setShelves(0);
            return Response.ok(courseBathEditClient.courseShelvesCheck(courseShelvesVo));
        }
    }

    @PostMapping("/bath/edit/strategy")
    @ApiOperation(value = "批量修改策略", notes = "批量策略修改")
    public Response courseStrategyEdit(@RequestBody BathEditCourseVo vo){
        Long accountId = ContextHolder.get().getAccountId();
        vo.setUpdateByaccountId(accountId);

        List<Long> editObject = vo.getEditObject();
        CourseVo courseVo = vo.getEditFields();
        Integer scope = courseVo.getScope();
        List<CourseAccountVO> courseAccountVOS = vo.getCourseAccounts();

        if(Objects.isNull(courseVo)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER6.getCode());
        }
        if(CollectionUtils.isEmpty(editObject)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER8.getCode());
        }
        if(Objects.nonNull(scope) && scope.intValue()==2 && CollectionUtils.isEmpty(courseAccountVOS)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER7.getCode());
        }
        if(CollectionUtils.isEmpty(editObject)){
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER8.getCode());
        }



        //List<Long> ids = editObject.stream().map(item->item.getId()).collect(Collectors.toList());
        List<CourseEntityVo> ignoreCourses = courseBathEditClient.courseStrategyCheck(editObject);

        if(!CollectionUtils.isEmpty(ignoreCourses)){
            List<Long> upCourse = new ArrayList<>();
            List<Long> ignoreCourseIds = ignoreCourses.stream().map(id->id.getId()).collect(Collectors.toList());
            for(Long item : editObject){
                if(!ignoreCourseIds.contains(item)){
                    upCourse.add(item);
                }
            }
            if(CollectionUtils.isEmpty(upCourse)){
                return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER9.getCode());
            }
            vo.setEditObject(upCourse);
        }

        boolean ret = courseBathEditClient.courseStrategyEdit(vo);
        if(ret){
            return Response.ok();
        }else {
            return Response.fail(InternationalEnums.COURSEBATHEDITCONTROLLER9.getCode());
        }
    }

    private static List<Long> getResponse(List<Long> editObject, List<Long> ignoreCourses) {
        if(CollectionUtils.isEmpty(ignoreCourses)){
            return null;
        }

        List<Long> courseCode =  new ArrayList<>();
        for(Long cid : editObject){
            if(ignoreCourses.contains(cid)){
                courseCode.add(cid);
            }
        }
        return courseCode;
    }
}
