package com.yizhi.application.drools;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.album.application.feign.AlbumClient;
import com.yizhi.application.drools.vo.DroolsParamsVo;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.assignment.application.feign.AssignmentClient;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.enums.TaskParamsEnums;
import com.yizhi.core.application.enums.TaskTypeEnums;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.course.application.feign.CourseClient;
import com.yizhi.exam.application.feign.ExamManageClient;
import com.yizhi.library.application.feign.CaseLibraryClient;
import com.yizhi.library.application.feign.StudentCaseClient;
import com.yizhi.live.application.feign.LiveActivityClient;
import com.yizhi.research.application.feign.ResearchClient;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.training.application.feign.TrainingProjectClient;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.page.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = "规则引擎管理端接口")
@RestController
@RequestMapping("/drools/manage/")
@Log4j2
public class DroolsManagerController {

    @Autowired
    private CourseClient courseClient;
    @Autowired
    private TrainingProjectClient trainingProjectClient;
    @Autowired
    private ExamManageClient examManageClient;
    @Autowired
    private AssignmentClient assignmentClient;
    @Autowired
    private ResearchClient researchClient;
    @Autowired
    private LiveActivityClient liveActivityClient;
    @Autowired
    private AccountClient accountClient;
    @Autowired
    private CaseLibraryClient caseLibraryClient;
    @Autowired
    private StudentCaseClient studentCaseClient;
    @Autowired
    private AlbumClient albumClient;
    @Resource
    private BizKeywordClient bizKeywordClient;

    @PostMapping("task/page")
    @ApiOperation(value = "搜索下拉框", response = DroolsVo.class)
    public Response getPage(@ApiParam("droolsParamsVo") @RequestBody DroolsParamsVo droolsParamsVo) {
        String taskType = droolsParamsVo.getTaskType();
        String field = droolsParamsVo.getTaskParamsType();
        String fieldValue = droolsParamsVo.getTaskParamsValue();
        if (StringUtils.isEmpty(taskType) || StringUtils.isEmpty(field)) {
            return Response.fail(InternationalEnums.DROOLSMANAGERCONTROLLER1.getCode());
        }

        Page<DroolsVo> page = new Page<>();
        // 关键词直接走搜索引擎
        if (droolsParamsVo.getTaskParamsType().equalsIgnoreCase("keyword")) {
            Map<String, String> map = new HashMap<>();
            map.put("pageNo", String.valueOf(droolsParamsVo.getPageNo()));
            map.put("pageSize", String.valueOf(droolsParamsVo.getPageSize()));
            map.put("taskType", droolsParamsVo.getTaskType());
            map.put("taskParamsType", droolsParamsVo.getTaskParamsType());
            map.put("taskParamsValue", droolsParamsVo.getTaskParamsValue());
            map.put("context", JSON.toJSONString(ContextHolder.get()));
            log.info("------------------------------------  param:  ----------------------------------------");
            log.info(JSON.toJSONString(map));
            log.info("------------------------------------  param:  ----------------------------------------");

            map = bizKeywordClient.keywordPage(map);

            log.info("------------------------------------  response:  ----------------------------------------");
            log.info(JSON.toJSONString(map));
            log.info("------------------------------------  response:  ----------------------------------------");

            String record = map.get("record");
            page = new Page<>(droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());
            if (!StringUtils.isEmpty(record)) {
                JSONArray jsonArray = JSON.parseArray(record);
                List<DroolsVo> list = jsonArray.toJavaList(DroolsVo.class);
                page.setRecords(list);
            }
            page.setTotal(Integer.parseInt(map.get("total")));
        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.COURSE.getTaskType())) {

            page = courseClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());

        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.TRAINING_PROJECT.getTaskType())) {

            page = trainingProjectClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());

        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.EXAM.getTaskType())) {

            page = examManageClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());

        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.ASSIGNMENT.getTaskType())) {

            page = assignmentClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());

        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.RESEARCH.getTaskType())) {

            page = researchClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());

        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.LIVE.getTaskType())) {

            page = liveActivityClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());

        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.CASE.getTaskType())) {
            if (TaskParamsEnums.AUTHOR.getCode().equals(field)) {
                PageInfo<DroolsVo> pageByDrools = accountClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());
                page.setRecords(pageByDrools.getRecords());
                page.setTotal(pageByDrools.getPageRecords());
            } else {
                page = studentCaseClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());
            }

        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.CASE_ACTIVITY.getTaskType())) {

            page = caseLibraryClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());

        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.SYSTEM.getTaskType())) {

            PageInfo<DroolsVo> pageByDrools = accountClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());
            page.setRecords(pageByDrools.getRecords());
            page.setTotal(pageByDrools.getPageRecords());
        } else if (taskType.equalsIgnoreCase(TaskTypeEnums.ALBUM.getTaskType())) {
            page = albumClient.getPageByDrools(field, fieldValue, droolsParamsVo.getPageNo(), droolsParamsVo.getPageSize());
        } else {
            return Response.fail(InternationalEnums.DROOLSMANAGERCONTROLLER2.getCode());
        }

        return Response.ok(page);
    }


}
