package com.yizhi.application.exam.controller;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.feign.ExamReportClient;
import com.yizhi.util.application.domain.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;



import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 考试统计-导出模块
 * @author mei
 *
 */
@Api(tags = "管理端-考试统计", description = "管理端-考试统计")
@RestController
@RequestMapping("/manage/exam")
public class ExamManageReportController {

	@Autowired
	ExamReportClient examReportClient;
	
	@ApiOperation(value = "导出考试答卷", notes = "导出考试答卷")  
	@GetMapping("/answer/student/export")
	public Response<Object> downStudentExamAnswer(
			HttpServletRequest request,
			@ApiParam(value = "考试ID", required = false) @RequestParam(name = "examId", required = false) String examId) {
		RequestContext requestContext = ContextHolder.get();
        if(null == requestContext){
        	Response.fail();
        }        
        Long companyId = requestContext.getCompanyId();
        Long siteId = requestContext.getSiteId();
        String urlPath=request.getContextPath();
		Map<String, Object> paramMaps = new HashMap<String, Object>();
		paramMaps.put("examId", examId);
		paramMaps.put("companyId", String.valueOf(companyId));
		paramMaps.put("siteId", String.valueOf(siteId));
		paramMaps.put("urlPath", urlPath);
		examReportClient.downStudentExamAnswer(paramMaps);
		
		return Response.ok();
	}
}
