package com.yizhi.application.exam.util;

import java.io.IOException;
import java.util.List;

import com.yizhi.exam.application.vo.ExportByExamVO;
import com.yizhi.exam.application.vo.ExportExamBySiteVO;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExportUtil {
	
	public HSSFWorkbook export(ExportExamBySiteVO vo) throws IOException {
		String exportName = vo.getExportName();
		String period = vo.getPeriod();
		String[] headers = vo.getHeaders();
		List<ExportByExamVO> vos = vo.getVos();
		// 创建新的Excel 工作簿
		HSSFWorkbook workBook = new HSSFWorkbook();
		
		// 在Excel工作簿中建一工作表，其名为缺省值
		HSSFSheet sheet = workBook.createSheet(exportName);
		sheet.setDefaultColumnWidth(15);
		CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 0, 7);
		sheet.addMergedRegion(cellRangeAddress);
		
		// 第一行
		HSSFRow row = sheet.createRow(0);
		HSSFCell cell = row.createCell(0);
		HSSFCellStyle createCellStyle = workBook.createCellStyle();
		createCellStyle.setAlignment(HorizontalAlignment.CENTER);
		cell.setCellStyle(createCellStyle);   // 居中
		cell.setCellValue(new HSSFRichTextString(exportName));

		// 第二行
		cellRangeAddress = new CellRangeAddress(1, 1, 0, 7);
		sheet.addMergedRegion(cellRangeAddress);
		row = sheet.createRow(1);
		cell = row.createCell(0);
		cell.setCellValue(period);
		
		// 第三行
		row = sheet.createRow(2);
		for(int i = 0; i < headers.length; i++){
			row.createCell(i).setCellValue(headers[i]);
		}
		
		ExportByExamVO evo = null;
		// 填充数据
		for (int i = 0; i < vos.size(); i++) {
			evo = vos.get(i);
			row = sheet.createRow(3 + i);
			row.createCell(0).setCellValue(evo.getName());
			row.createCell(1).setCellValue(evo.getStartTime());
			row.createCell(2).setCellValue(evo.getEndTime());
			row.createCell(3).setCellValue(evo.getJoinNo());
			row.createCell(4).setCellValue(evo.getActualNo());
			row.createCell(5).setCellValue(evo.getPassNo());
			row.createCell(6).setCellValue(evo.getAvgScore());
			row.createCell(7).setCellValue(evo.getCompleteRate());
		}
		return workBook;
	}

}
