package com.yizhi.application.forum.statistic;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.forum.application.vo.forum.StatisticsForumAccountVo;
import com.yizhi.statistics.application.entity.StatisticsForum;
import com.yizhi.statistics.application.feign.StatisticsForumAccountClient;
import com.yizhi.statistics.application.feign.StatisticsForumClient;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Api(tags = "管理端-论坛统计接口")
@RestController
@RequestMapping("/manage/statistic/forum")
public class StatisticController {

    private static final Logger LOG = LoggerFactory.getLogger(StatisticController.class);


    @Autowired
    private StatisticsForumAccountClient statisticsForumAccountClient;

    @Autowired
    private StatisticsForumClient statisticsForumClient;
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    /**
     * 按帖子统计
     *
     * @param keyword
     * @param pageNo
     * @param pageSize
     * @return
     */
    @ApiOperation("论坛统计-按帖子统计分页列表")
    @GetMapping("/statisticsForum/getPage")
    public Response<Page<StatisticsForum>> getPage(@ApiParam("关键字") @RequestParam(value = "keyword", required = false) String keyword,
                                                   @ApiParam("开始时间") @RequestParam(value = "startDate", required = false) String startDate,
                                                   @ApiParam("结束时间") @RequestParam(value = "endDate", required = false) String endDate,
                                                   @ApiParam("当前页数") @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
                                                   @ApiParam("页内条数") @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {

        return Response.ok(statisticsForumClient.getPage(keyword, startDate, endDate, pageNo, pageSize));
    }

    /**
     * 按帖子下载
     *
     * @param keyword
     * @return
     */
    @ApiOperation("论坛统计-按帖子统计下载")
    @GetMapping("/statisticsForum/download")
    public Response download(@ApiParam("关键字") @RequestParam(value = "keyword", required = false) String keyword,
                             @ApiParam("开始时间") @RequestParam(value = "startDate", required = false) String startDate,
                             @ApiParam("结束时间") @RequestParam(value = "endDate", required = false) String endDate) {
        RequestContext requestContext = ContextHolder.get();
        Date submitTime = new Date();
        Long currentTaskId = submitTime.getTime();
        String serialNo = "FORUM-EXPORT-" + currentTaskId;
        String currentTaskName = "论坛报表--按帖子统计导出" + "_" + currentTaskId;

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", requestContext.getAccountId());
        map.put("siteId", requestContext.getSiteId());
        map.put("companyId", requestContext.getCompanyId());
        map.put("serialNo", serialNo);
        map.put("submitTime", submitTime);
        map.put("keyword", keyword);
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        map.put("currentTaskId", currentTaskId);
        map.put("currentTaskName", currentTaskName);

        try {
            statisticsForumClient.download(map);
            return Response.ok("导出成功," + " 任务编号：" + serialNo + "  任务名称:" + currentTaskName);
        } catch (Exception e) {
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 按用户统计
     *
     * @param keyword
     * @param pageNo
     * @param pageSize
     * @return
     */
    @ApiOperation("论坛统计-按用户统计分页列表")
    @GetMapping("/statisticsForumAccount/getPage")
    public Response<Page<StatisticsForumAccountVo>> getPage(@ApiParam("关键字") @RequestParam(value = "keyword", required = false) String keyword,
                                                            @ApiParam("当前页数") @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
                                                            @ApiParam("页内条数") @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {
        return Response.ok(statisticsForumAccountClient.getPage(keyword, pageNo, pageSize));
    }

    /**
     * 按用户统计下载
     *
     * @param keyword
     * @return
     */
    @ApiOperation("论坛统计-按用户统计下载")
    @GetMapping("/statisticsForumAccount/download")
    public Response download(@ApiParam("关键字") @RequestParam(value = "keyword", required = false) String keyword) {
        RequestContext requestContext = ContextHolder.get();
        Date submitTime = new Date();
        Long currentTaskId = submitTime.getTime();
        String serialNo = "ACCOUNT_FORUM-EXPORT-" + currentTaskId;
        String currentTaskName = "论坛报表--按用户统计导出" + "_" + currentTaskId;

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", requestContext.getAccountId());
        map.put("siteId", requestContext.getSiteId());
        map.put("companyId", requestContext.getCompanyId());
        map.put("serialNo", serialNo);
        map.put("submitTime", submitTime);
        map.put("keyword", keyword);
        map.put("currentTaskId", currentTaskId);
        map.put("currentTaskName", currentTaskName);

        try {
            statisticsForumAccountClient.download(map);
            return Response.ok("导出成功," + " 任务编号：" + serialNo + "  任务名称:" + currentTaskName);
        } catch (Exception e) {
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }
}
