package com.yizhi.application.lecturer.Controller;

import com.yizhi.lecturer.application.feign.LecturerClient;
import com.yizhi.lecturer.application.vo.FileUploadModel;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.log4j.Log4j2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 讲师库字典
 * @author: lly
 * @date: 2019-04-18 11:50
 **/
@Log4j2
@Api(tags = "讲师导入")
@RestController
@RequestMapping("/manage/lecturer/import")
public class LecturerImportController {

    private static final Logger LOG = LoggerFactory.getLogger(LecturerImportController.class);

    @Autowired
    private LecturerClient lecturerClient;

    @ApiOperation(value = "导入讲师评级", notes = "导入讲师评级")
    @PostMapping(value = "/score")
    public Response<String> importScore(@RequestBody FileUploadModel model) {
        try {
            String taskLogSerialNo = lecturerClient.importScore(model);
            return Response.ok(taskLogSerialNo);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }
    }

    @ApiOperation(value = "导入讲师评级", notes = "导入讲师评级")
    @PostMapping(value = "/grade")
    public Response<String> importGrade(@RequestBody FileUploadModel model) {
        try {
            String taskLogSerialNo = lecturerClient.importGrade(model);
            return Response.ok(taskLogSerialNo);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }
    }

    @ApiOperation(value = "导入讲师相关课程", notes = "导入教师相关课程")
    @PostMapping(value = "/course")
    public Response<String> importCourse(@RequestBody FileUploadModel model) {
        try {
            String taskLogSerialNo = lecturerClient.importCourse(model);
            return Response.ok(taskLogSerialNo);
        } catch (Exception e) {
            return Response.fail(Constants.LECTURER_MSG_BIZ_ERROR);
        }
    }
}