package com.yizhi.application.offlineCourse;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.course.vo.OfflineClassifySortUpdateVo;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.feign.OfflineClassifyClient;
import com.yizhi.course.application.vo.OfflineClassifyVo;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author huangliang
 * @Date 2018/10/16
 */
@Api(tags = "管理端-线下课程分类", description = "线下课程分类接口")
@RestController
@RequestMapping("/manage/offlineClassify")
public class OfflineCourseClassifyController {

    @Autowired
    private OfflineClassifyClient offlineClassifyClient;


    private Logger logger = LoggerFactory.getLogger(OfflineCourseClassifyController.class);

    @ApiOperation(value = "线下课程分类删除")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    public Response<Integer> delete(@ApiParam(value = "传入map") @RequestBody Map<String, String> map) {
        try {
            int result = offlineClassifyClient.delete(map);
            if (result > 0) {
                return Response.ok();
            } else {
                return Response.fail(InternationalEnums.OFFLINECOURSECLASSIFYCONTROLLER1.getCode());
            }
        } catch (Exception e) {
            logger.error("删除失败", e);
            return Response.fail();
        }
    }

    @ApiOperation(value = "线下课程添加分类")
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public Response<Integer> saveOfflineClassify(@ApiParam(value = "传入") @RequestBody OfflineClassifyVo offlineClassify) {
        RequestContext requestContext = ContextHolder.get();
        offlineClassify.setCreateById(requestContext.getAccountId());
        offlineClassify.setCreateByName(requestContext.getAccountName());
        offlineClassify.setCreateTime(new Date());
        offlineClassify.setCompanyId(requestContext.getCompanyId());
        offlineClassify.setSiteId(requestContext.getSiteId());
        offlineClassify.setOrgId(requestContext.getOrgId());
        offlineClassify.setSource(1);
        try {
            Integer result = offlineClassifyClient.saveOfflineClassify(offlineClassify);
            if (result == 1) {
                return Response.ok();
            }
            else if(result == -1){
                return Response.fail("4001",InternationalEnums.OFFLINECOURSECLASSIFYCONTROLLER2.getCode());
            }
            else {
                return Response.fail("4001",InternationalEnums.OFFLINECOURSECLASSIFYCONTROLLER3.getCode());
            }
        } catch (Exception e) {
            logger.error("添加失败", e);
            return Response.fail();
        }
    }

    @ApiOperation("线下课程分类名称修改")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public Response<Integer> updateOfflineClassify(@ApiParam(value = "传入") @RequestBody OfflineClassifyVo offlineClassify) {
        RequestContext requestContext = ContextHolder.get();
        Long accountId = requestContext.getAccountId();
        String accountName = requestContext.getAccountName();
        offlineClassify.setUpdateById(accountId);
        offlineClassify.setUpdateByName(accountName);
        offlineClassify.setCreateTime(new Date());
        try {
         int i = offlineClassifyClient.updateOfflineClassify(offlineClassify);
         if(i == -1){
             return Response.fail("4001",InternationalEnums.OFFLINECOURSECLASSIFYCONTROLLER4.getCode());
         }
         else if(i == -2){
             return  Response.fail("4001",InternationalEnums.OFFLINECOURSECLASSIFYCONTROLLER5.getCode());
         }
         else if(i == 0){
             return Response.fail("4001",InternationalEnums.DOCUMENTCLASSIFYCOMTROLLER3.getCode());
         }
        } catch (Exception e) {
            logger.error("修改失败", e);
            return Response.fail();
        }
        return Response.ok();
    }

    @ApiOperation("线下课程分类排序")
    @RequestMapping(value = "/sort/update", method = RequestMethod.POST)
    public Response<Integer> offlineClassifySort(
            @ApiParam(value = "") @RequestBody List<OfflineClassifySortUpdateVo> list) {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return Response.fail("4001", InternationalEnums.OFFLINECOURSECLASSIFYCONTROLLER6.getCode());
            }

            RequestContext context = ContextHolder.get();
            Date date = new Date();

            List<OfflineClassifyVo> offlineClassifies = new ArrayList<>(list.size());
            OfflineClassifyVo classify = null;
            for (OfflineClassifySortUpdateVo vo : list) {
                classify = new OfflineClassifyVo();
                classify.setId(vo.getId());
                classify.setSort(vo.getSort());
                classify.setUpdateByName(context.getAccountName());
                classify.setUpdateById(context.getAccountId());
                classify.setUpdateTime(date);
                offlineClassifies.add(classify);
            }
            return Response.ok(offlineClassifyClient.offlineClassifySort(offlineClassifies));
        } catch (Exception e) {
            logger.error("排序失败", e);
            return Response.fail();
        }
    }

    @ApiOperation(value = "线下课程分类分页查询", response = OfflineClassifyVo.class)
    @RequestMapping(value = "/page/list", method = RequestMethod.GET)
    public Response pageList(
            @ApiParam(required = false, value = "分类名称") @RequestParam(value = "name", required = false) String name,
            @ApiParam(name = "pageNo", value = "跳转页数,默认第一页") @RequestParam(name = "pageNo", defaultValue = "1", required = false) Integer pageNo,
            @ApiParam(name = "pageSize", value = "每页条数,默认20条") @RequestParam(name = "pageSize", defaultValue = "10", required = false) Integer pageSize
    ) {
        Page<OfflineClassifyVo> page = offlineClassifyClient.pageList(name, pageNo, pageSize);
        return Response.ok(page);
    }

    @ApiOperation(value = "分类查询", response = OfflineClassifyVo.class)
    @RequestMapping(value = "/list", method = RequestMethod.POST)
    public Response<List> listOfflineClassify() {
        List<OfflineClassifyVo> offlineClassifies = offlineClassifyClient.listOfflineClassify();
        return Response.ok(offlineClassifies);
    }
}