package com.yizhi.application.point.controller;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.point.application.feign.PointActivityFeignClients;
import com.yizhi.point.application.vo.domain.PointActivityVo;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 我的积分
 * @author mei
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "活动策略 管理端")
@RestController
@RequestMapping("/manage/activity")
public class PointActivityController {
	
	private static final Logger LOG = LoggerFactory.getLogger(PointActivityController.class);
	
	@Autowired
	PointActivityFeignClients pointActivityFeignClients;
	
	@ApiOperation(value = "积分活动策略新增", notes = "积分活动策略新增")
	@PostMapping("/insert")
	public Response<Long> insertDetail(@RequestBody PointActivityVo pointActivity){
		if(null == pointActivity){
			return Response.fail();
		}

		RequestContext requestContext = ContextHolder.get();
		if (null == requestContext) {
			Response.fail();
		}
		Long companyId = requestContext.getCompanyId();
		Long siteId = requestContext.getSiteId();
		Long orgId = requestContext.getOrgId();
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		Date date = new Date();
		
		pointActivity.setCompanyId(companyId);
		pointActivity.setSiteId(siteId);
		pointActivity.setOrgId(orgId);
		pointActivity.setCreateById(accountId);
		pointActivity.setCreateByName(accountName);
		pointActivity.setCreateTime(date);
		pointActivity.setUpdateById(accountId);
		pointActivity.setUpdateByName(accountName);
		pointActivity.setUpdateTime(date);
		
		return Response.ok(pointActivityFeignClients.insertDetail(pointActivity));
	}

	@ApiOperation(value = "积分活动策略删除")
	@PostMapping("/delete")
	public Response<Long> deleteDetailById(@RequestBody PointActivityVo pointActivity) {
		if (null == pointActivity) {
			return Response.fail();
		}
		long i = pointActivityFeignClients.deleteDetailById(pointActivity);

		if (i == -1L) {
			Response.fail(InternationalEnums.POINTACTIVITYCONTROLLER.getCode());

		}
		return Response.ok();
	}

	@ApiOperation(value = "积分活动策略修改", notes = "积分活动策略修改")
	@PostMapping("/update")
	public Response<Long> updateById(@RequestBody PointActivityVo pointActivity){
		if(null == pointActivity){
			return Response.fail();
		}

		RequestContext requestContext = ContextHolder.get();
		if (null == requestContext) {
			Response.fail();
		}
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		Date date = new Date(); 
		pointActivity.setUpdateById(accountId);
		pointActivity.setUpdateByName(accountName);
		pointActivity.setUpdateTime(date);
		return Response.ok(pointActivityFeignClients.updateById(pointActivity));
	}
	
	@ApiOperation(value = "积分活动策略启用", notes = "积分活动策略启用")
	@PostMapping("/enabled")
	Response<Boolean> bannerUp(@RequestBody PointActivityVo pointActivity){
		if(null == pointActivity){
			return Response.fail();
		}

		RequestContext requestContext = ContextHolder.get();
		if (null == requestContext) {
			Response.fail();
		}
 
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		pointActivity.setUpdateById(accountId);
		pointActivity.setUpdateByName(accountName);
		
		return Response.ok(pointActivityFeignClients.pointUp(pointActivity));
	}
	
	@ApiOperation(value = "积分活动策略停用", notes = "积分活动策略停用")
	@PostMapping("/disabled")
	Response<Boolean> bannerDown(@RequestBody PointActivityVo pointActivity){
		if(null == pointActivity){
			return Response.fail();
		}
		
		RequestContext requestContext = ContextHolder.get();
		if (null == requestContext) {
			Response.fail();
		}
 
		Long accountId = requestContext.getAccountId();
		String accountName = requestContext.getAccountName();
		pointActivity.setUpdateById(accountId);
		pointActivity.setUpdateByName(accountName);
		
		return Response.ok(pointActivityFeignClients.pointDown(pointActivity));
	}
	
	@ApiOperation(value = "积分活动策略查询、分页列表", notes = "积分活动策略查询、分页列表", response = PointActivityVo.class)
	@GetMapping("/list")
	public Response<Object> activityList(
			 @RequestParam(name = "activityName",required = false)String activityName,
			 @RequestParam(name = "code",required = false)String code,
			 @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
			 @RequestParam(name = "pageNo", required = false, defaultValue = "1") Integer pageNo){
		Page<PointActivityVo> list = null;
		
		RequestContext requestContext = ContextHolder.get();
        if(null == requestContext){
        	Response.fail();
        }
        
        Long companyId = requestContext.getCompanyId();
        Long siteId = requestContext.getSiteId();
        
		try {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("companyId", companyId);
			map.put("siteId", siteId);
			map.put("activityName", activityName);
			map.put("code", code);
			map.put("pageNo", pageNo);
			map.put("pageSize", pageSize);
			list = pointActivityFeignClients.activityList(map);
			
			Map<String, Integer> pageMap = new HashMap<String, Integer>();
			pageMap.put("pageNo", pageNo);
			pageMap.put("pageSize", pageSize);
			pageMap.put("pageTotal", list.getTotal()); 
			if(null != list){
				return Response.ok(list.getRecords(), pageMap);
			}
		} catch (Exception e) {
			LOG.error("服务出错。", e);
			return Response.fail();
		}
		
		return Response.fail();
	}
}
