package com.yizhi.application.point.controller;

import com.yizhi.point.application.feign.PointLevelFeignClients;
import com.yizhi.point.application.vo.domain.PointLevelVo;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 我的积分
 * @author mei
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "积分等级设置  管理端")
@RestController
@RequestMapping("/manage/point/level")
public class PointLeverController {
	
	private static final Logger LOG = LoggerFactory.getLogger(PointLeverController.class);
	
	@Autowired
	PointLevelFeignClients pointLevelFeignClients;
	
	@ApiOperation(value = "积分等级新增", notes = "积分等级新增")
	@PostMapping("/insert")
	public Response<String> inserts( PointLevelVo pointLevel){
		return Response.ok(pointLevelFeignClients.inserts(pointLevel));
	
	}
	

	@ApiOperation(value = "积分等级删除", notes = "积分等级删除")
	@PostMapping("/delete")
	public Response<String> piontLevelDelete(
			@ApiParam(name = "id", value = "积分等级删除") @RequestParam(name = "id", required = true) Long id){
		return Response.ok(pointLevelFeignClients.piontLevelDelete(id));
	}
	
	@ApiOperation(value = "积分等级列表", notes = "积分等级列表")
	@GetMapping("/list")
	public Response<PointLevelVo> levelList(
			 @RequestParam(name = "id",required = true) Long id){
		return Response.ok(pointLevelFeignClients.levelList(id));
	}
	@ApiOperation(value = "积分等级修改", notes = "积分等级修改")
	@GetMapping("/update")
	public Response<Integer> updateById(PointLevelVo pointLevel) {
		return Response.ok(pointLevelFeignClients.updateById1(pointLevel));
	}
}
