package com.yizhi.application.portal.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.point.application.feign.PointFeignClients;
import com.yizhi.point.application.feign.PointListenerClients;
import com.yizhi.site.application.feign.api.EventTrackApiClients;
import com.yizhi.training.application.feign.LeaveWordClient;
import com.yizhi.training.application.vo.domain.LeaveWordParamVo;
import com.yizhi.training.application.vo.domain.LeaveWordVo;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * com.yizhi.application.portal.controller
 *
 * @author yanglang
 * @create 2025-01-03 13:42:52
 */
@Api(tags = "管理端-留言管理", description = "留言管理")
@RestController
@RequestMapping("/manage/leaveWord")
public class LeaveWordManageController {
    private Logger logger = LoggerFactory.getLogger(LeaveWordManageController.class);

    @Autowired
    private LeaveWordClient leaveWordClient;

    @Autowired
    private PointListenerClients pointListenerClients;
    @Autowired
    private PointFeignClients pointFeignClients;

    @Autowired
    private EventTrackApiClients eventTrackApiClients;
    @Autowired
    private RedisCache redisCache;


    @PostMapping("/page")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    public Response<Page<LeaveWordVo>> page(@ApiParam(name = "leaveWordParamVo", value = "") @RequestBody LeaveWordParamVo leaveWordParamVo){
        try {
            Page<LeaveWordVo> page = leaveWordClient.page(leaveWordParamVo);
            return Response.ok(page);
        }catch (Exception e){
            logger.error("分页查询失败");
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }


    @PostMapping("/pageByMy")
    @ApiOperation(value = "我的分页查询", notes = "我的分页查询")
    public Response<Page<LeaveWordVo>> pageByMy(HttpServletRequest request,@ApiParam(name = "leaveWordParamVo", value = "") @RequestBody LeaveWordParamVo leaveWordParamVo){
        try {
            RequestContext context = ContextHolder.get();
            leaveWordParamVo.setCreateById(context.getAccountId());
            Page<LeaveWordVo> page = leaveWordClient.page(leaveWordParamVo);
            // 添加留言埋点
            if(request.getHeader("Cookie")!=null&&Objects.equals(redisCache.get(request.getHeader("Cookie").replace("JSESSIONID=","")),"2")){
                eventTrackApiClients.addEvent("leave_word",context.getAccountId());
            }
            return Response.ok(page);
        }catch (Exception e){
            logger.error("分页查询失败");
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }


    @PostMapping("/save")
    @ApiOperation(value = "保存", notes = "保存")
    public Response save(@ApiParam(name = "leaveWordVo", value = "") @RequestBody LeaveWordVo leaveWordVo){
        try {
            return Response.ok(leaveWordClient.save(leaveWordVo));
        }catch (Exception e){
            logger.error("保存失败");
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }


    @GetMapping("/getById")
    @ApiOperation(value = "查询", notes = "查询")
    public Response<LeaveWordVo> getById(@ApiParam(name = "id", value = "")@RequestParam(name = "id")Long id){
        try {
            return Response.ok(leaveWordClient.getById(id));
        }catch (Exception e){
            logger.error("查询失败");
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }


    @GetMapping("/updateState")
    @ApiOperation(value = "修改状态", notes = "修改状态")
    public Response updateState(@ApiParam(name = "id", value = "")@RequestParam(name = "id")Long id,@ApiParam(name = "state", value = "")@RequestParam(name = "state")Integer state){
        try {
            boolean flase =leaveWordClient.updateState(id,state);
            if(false&&state==2){
                //pointFeignClients.addPoint(0,"point_comment", id);
            }
            return Response.ok(flase);
        }catch (Exception e){
            logger.error("修改状态失败");
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }

    @GetMapping("/removeById")
    @ApiOperation(value = "删除", notes = "删除")
    public Response removeById(@ApiParam(name = "id", value = "")@RequestParam(name = "id")Long id){
        try {
            return Response.ok(leaveWordClient.removeById(id));
        }catch (Exception e){
            logger.error("删除失败");
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }
}
