package com.yizhi.application.portal.controller;

import java.util.Date;
import java.util.List;

import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.site.application.feign.ClassifyManageFeignClients;
import com.yizhi.site.application.vo.domain.DataClassificationVo;
import com.yizhi.site.application.vo.site.*;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 资讯分类
 * 
 * @author mei
 * @Date: 2018/3/17 20:30
 */

@Api(tags = "资讯分类")
@RestController
@RequestMapping("/manage")
public class SiteClassifyManageController {
	private static final Logger LOGGER = LoggerFactory.getLogger(SiteClassifyManageController.class);
	@Autowired
	private ClassifyManageFeignClients classifyManageFeignClients;

	@ApiOperation(value = "根据父类id获得子级", notes = "根据父类id获得子级", response = DataClassificationVo.class)
	@GetMapping("/classify/childnode/find")
	public Response<DataClassificationVo> getSon(
			@ApiParam(name = "parentId", value = "父级id", required = true) @RequestParam(name = "parentId", required = true) Long parentId) {
		try {
			List<DataClassificationVo> data = classifyManageFeignClients.getInformation(parentId);
			return Response.ok(data);
		} catch (Exception e) {
			LOGGER.error("", e);
			e.printStackTrace();
			return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
		}
	}

	@ApiOperation(value = "查看资料分类", notes = "查看资料分类", response = ClassificationVO.class)
	@GetMapping("/site/classify/list")
	public Response<ClassificationVO> list() {
		try {
			SiteComponyIdVO siteComponyIdVO = new SiteComponyIdVO();
			siteComponyIdVO.setCompanyId(ContextHolder.get().getCompanyId());
			siteComponyIdVO.setSiteId(ContextHolder.get().getSiteId());
			siteComponyIdVO.setCreateById(ContextHolder.get().getAccountId());
			siteComponyIdVO.setCreateByName(ContextHolder.get().getAccountName());
			siteComponyIdVO.setOrgId(ContextHolder.get().getOrgId());
			siteComponyIdVO.setSiteId(ContextHolder.get().getSiteId());
			return Response.ok(classifyManageFeignClients.getClassification(siteComponyIdVO));
		} catch (Exception e) {
			LOGGER.error("", e);
			e.printStackTrace();
			return Response.fail(ReturnCode.RESOURCE_NOT_FOUND.getCode(),ReturnCode.RESOURCE_NOT_FOUND.getMsg());
		}
	}

	@ApiOperation(value = "保存资料分类", notes = "保存资料分类")
	@PostMapping("/site/classify/insert")
	public Response<Boolean> insertClassify(@RequestBody DataClassificationVo dataClassification) {
		try {
			Long siteId = ContextHolder.get().getSiteId();
			Long accountId = ContextHolder.get().getAccountId();
			String accountName = ContextHolder.get().getAccountName();
			Date date = new Date();
			dataClassification.setCreateById(accountId);
			dataClassification.setCreateByName(accountName);
			dataClassification.setCreateTime(date);
			dataClassification.setUpdateById(accountId);
			dataClassification.setUpdateByName(accountName);
			dataClassification.setUpdateTime(date);
			dataClassification.setSiteId(siteId);
			return Response.ok(classifyManageFeignClients.insertClassify(dataClassification));
		} catch (Exception e) {
			e.printStackTrace();
			LOGGER.error("", e);
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}

	@ApiOperation(value = "修改分类资料,未修改的属性也一并传入。", notes = "修改分类资料")
	@PostMapping("/site/classify/update")
	public Response<Boolean> updateClassify(@RequestBody DataClassificationVo dataClassification) {
		try {
			dataClassification.setUpdateById(ContextHolder.get().getAccountId());
			dataClassification.setUpdateByName(ContextHolder.get().getAccountName());
			dataClassification.setUpdateTime(new Date());
			return Response.ok(classifyManageFeignClients.updateClassify(dataClassification));
		} catch (Exception e) {
			e.printStackTrace();
			LOGGER.error("", e);
			return Response.fail(ReturnCode.UPDATE_FAIL.getCode(),ReturnCode.UPDATE_FAIL.getMsg());
		}
	}

	@ApiOperation(value = "查看资料分类父类", notes = "查看资料分类父类", response = DataClassificationVo.class)
	@GetMapping("/site/classify/select")
	public Response<DataClassificationVo> select() {
		try {
			RequestContext context = ContextHolder.get();
			return Response.ok(classifyManageFeignClients.selectParent(context));
		} catch (Exception e) {
			e.printStackTrace();
			LOGGER.error("", e);
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}
	}

	@ApiOperation(value = "删除资料分类", notes = "删除资料分类")
	@PostMapping("/site/classify/delete")
	public Response<Boolean> delete(@RequestBody IdOneVO vo) {
        if(vo == null){
            return Response.fail(InternationalEnums.SITECLASSIFYMANAGECOMTROLLER2.getName());
        }
        if(vo.getId() == null){
            return Response.fail(InternationalEnums.SITECLASSIFYMANAGECOMTROLLER2.getName());
        }
        RespVO respVO = null;
        try {
            RequestContext context = ContextHolder.get();
            vo.setContext(context);
            respVO = classifyManageFeignClients.deleteClassify(vo);


        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("", e);

        }
        if(respVO!=null){
            return Response.fail("0",respVO.getSubMsg());
        } else {
            return Response.ok();
        }
	}
	
	@ApiOperation(value = "分类排序拖拽", notes = "分类排序拖拽")
	@PostMapping("/site/classify/drag")
	public Response<Boolean> dragClassify(@RequestBody IdTwoVO vo) {
		if(vo == null){
			return Response.fail(InternationalEnums.SITECLASSIFYMANAGECOMTROLLER2.getName());
		}
		try {
			RequestContext context = ContextHolder.get();
			vo.setAccountId(context.getAccountId());
			vo.setAccountName(context.getAccountName());
			return Response.ok(classifyManageFeignClients.dragClassify(vo));
		} catch (Exception e) {
			e.printStackTrace();
			LOGGER.error("", e);
			return Response.fail(ReturnCode.DELETE_FAIL.getCode(),ReturnCode.DELETE_FAIL.getMsg());
		}
	}

	@ApiOperation(value = "查找分类下是否有资讯 0 表示没有资讯，1表示有资讯", notes = "查找分类下是否有资讯")
	@GetMapping("/site/classify/information/select")
	public Response<String> selectInformation(
			@ApiParam(name = "typeTwo", value = "文章子类型", required = true) @RequestParam(name = "typeTwo", required = true) Long typeTwo) {
		try {
			Integer size = classifyManageFeignClients.selectInformation(typeTwo).size();
			if (size > 0) {
				return Response.ok("1");
			} else {
				return Response.ok("0");
			}
		} catch (Exception e) {
			e.printStackTrace();
			LOGGER.error("", e);
			return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
		}

	}

}
