package com.yizhi.application.rangeExport;

import java.util.Map;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.exam.application.feign.ExamAuthorizeClient;
import com.yizhi.exam.application.vo.exam.VisibleRangeExport;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExamVisibleRangeExport extends AbstractDefaultTask<String, Map<String,Object>> {
	
	
	private static final Logger logger = LoggerFactory.getLogger(ExamVisibleRangeExport.class);
	

	@Autowired
	private ExamAuthorizeClient examAuthorizeClient;
	@Autowired
	private AccountRangeClient accountRangeClient;
	
	

	@Override
	protected String execute(Map<String, Object> map) {
		// TODO Auto-generated method stub
		Long examId=(Long) map.get("examId");
		RequestContext context=(RequestContext) map.get("context");
		
		VisibleRangeExport visibleRangeExport=examAuthorizeClient.exportVisibleRange(examId);
		AccountRangeExportParam accountRangeImportParam=new AccountRangeExportParam();
		if(visibleRangeExport!=null) {
			accountRangeImportParam.setAccountIds(visibleRangeExport.getAccountIds());
			accountRangeImportParam.setBizName(visibleRangeExport.getBizName());
			accountRangeImportParam.setContext(context);
			accountRangeImportParam.setOrgIds(visibleRangeExport.getOrgIds());
		}
		System.out.println(accountRangeImportParam);
		String result=accountRangeClient.doExport(accountRangeImportParam);
		return result;
		 
	}

}
