package com.yizhi.application.rangeExport;

import java.util.Map;

import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.live.application.feign.LiveActivityClient;
import com.yizhi.live.application.vo.VisibleRangeExport;
import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LiveVisibleRangeExport extends AbstractDefaultTask<String, Map<String,Object>> {
	
	
	private static final Logger logger = LoggerFactory.getLogger(LiveVisibleRangeExport.class);
	

	@Autowired
	private LiveActivityClient liveActivityClient;
	@Autowired
	private AccountRangeClient accountRangeClient;
	
	

	@Override
	protected String execute(Map<String, Object> map) {
		// TODO Auto-generated method stub
		Long liveId=(Long) map.get("liveId");
		RequestContext context=(RequestContext) map.get("context");
		
		logger.info("111111111111112323232323进入直播查找可见范围,直播ID：{}",liveId);
		VisibleRangeExport visibleRangeExport=liveActivityClient.exportVisibleRange(liveId);
		logger.info("111111111111112323232323111111335进入直播查找可见范围,直播可见范围：{}",visibleRangeExport);
		AccountRangeExportParam accountRangeImportParam=new AccountRangeExportParam();
		if(visibleRangeExport!=null) {
			accountRangeImportParam.setAccountIds(visibleRangeExport.getAccountIds());
			accountRangeImportParam.setBizName(visibleRangeExport.getBizName());
			accountRangeImportParam.setContext(context);
			accountRangeImportParam.setOrgIds(visibleRangeExport.getOrgIds());
		}
		logger.info("1111111111111123232323236454542424274格式转换：{}",visibleRangeExport.toString());
		
		
		
		
		System.out.println(accountRangeImportParam);
		String result=accountRangeClient.doExport(accountRangeImportParam);
		return result;
		 
	}

}
