package com.yizhi.application.rangeExport;

import com.yizhi.application.customProject.contoller.ExperiencePoolRangeExport;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.exam.application.feign.ExamAuthorizeClient;
import com.yizhi.research.application.feign.ResearchAuthorizeClient;
import com.yizhi.research.application.vo.VisibleRangeExport;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 *
 * @author wangfeida
 *
 */
@Api(tags = "可见范围导出", description = "可见范围导出")
@RestController
@RequestMapping("/manage/range/export/")
public class RangeExportController {



	@Autowired
	private AssignmentVisibleRangeExport assignmentVisibleRangeExport;

	@Autowired
	private ExamVisibleRangeExport examVisibleRangeExport;

	@Autowired
	private CourseVisibleRangeExport courseVisibleRangeExport;


	@Autowired
	private LiveVisibleRangeExport liveVisibleRangeExport;

	@Autowired
	private ResearchVisibleRangeExport researchVisibleRangeExport;

	@Autowired
	private TrainingProjectVisibleRangeExport trainingProjectVisibleRangeExport;
	@Autowired
	private ResearchAuthorizeClient researchAuthorizeClient;
	@Autowired
	private ExamAuthorizeClient examAuthorizeClient;

//	@Autowired
//	private VoteVisibleRangeExport voteVisibleRangeExport;

	@Autowired
	private ExperiencePoolRangeExport poolRangeExport;

	@Autowired
	private CaseLibraryRangeExport caseLibraryRangeExport;

	@Value("${pc.host.url}")
	String pcHostUrl;


	@ApiOperation(value="作业可见范围导出",notes="作业可见范围导出1")
	@GetMapping("/assignment")
	public Response<String> exportVisibleRangeAssignment(HttpServletRequest request,
			@ApiParam(name="assignmentId",value="作业id", required = true) @RequestParam(name = "assignmentId", required = true) Long assignmentId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("assignmentId", assignmentId);
		map.put("context", ContextHolder.get());
		String result=(String) assignmentVisibleRangeExport.execute(map, false);
		return Response.ok(result);
	}





	@ApiOperation(value="考试可见范围导出",notes="考试可见范围导出1")
	@GetMapping("/exam")
	public Response<String> exportVisibleRangeExam(HttpServletRequest request,
			@ApiParam(name="examId",value="考试id", required = true) @RequestParam(name = "examId", required = true) Long examId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("examId", examId);
		map.put("context", ContextHolder.get());
		String result=(String)examVisibleRangeExport.execute(map, false);
		com.yizhi.exam.application.vo.exam.VisibleRangeExport visibleRangeExport=examAuthorizeClient.exportVisibleRange(examId);
		String fileNamePattern = visibleRangeExport.getBizName().replaceAll("/", ".") + "-可见范围导出";
		fileNamePattern = fileNamePattern + DateFormatUtils.format(new Date(), "yyyyMMdd") + ".xls";
		fileNamePattern = pcHostUrl+"/api/v1/buckets/upload/objects/download/?preview=true&prefix="+fileNamePattern;
		return Response.ok(fileNamePattern);
	}



	@ApiOperation(value="课程可见范围导出",notes="课程可见范围导出1")
	@GetMapping("/course")
	public Response<String> exportVisibleRangeCourse(HttpServletRequest request,
			@ApiParam(name="courseId",value="课程ID", required = true) @RequestParam(name = "courseId", required = true) Long courseId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("courseId", courseId);
		map.put("context", ContextHolder.get());
		String result=(String)courseVisibleRangeExport.execute(map, false);
		return Response.ok(result);
	}



	@ApiOperation(value="调研可见范围导出",notes="调研可见范围导出1")
	@GetMapping("/research")
	public Response<String> exportVisibleRangeResearch(HttpServletRequest request,
			@ApiParam(name="researchId",value="调研ID", required = true) @RequestParam(name = "researchId", required = true) Long researchId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("researchId", researchId);
		map.put("context", ContextHolder.get());
		String result=(String)researchVisibleRangeExport.execute(map, false);
		VisibleRangeExport visibleRangeExport=researchAuthorizeClient.exportVisibleRange(researchId);
		String fileNamePattern = visibleRangeExport.getBizName().replaceAll("/", ".") + "-可见范围导出";
		fileNamePattern = fileNamePattern + DateFormatUtils.format(new Date(), "yyyyMMdd") + ".xls";
		fileNamePattern = pcHostUrl+"/api/v1/buckets/upload/objects/download/?preview=true&prefix="+fileNamePattern;
		return Response.ok(fileNamePattern);
	}




//	@ApiOperation(value="投票可见范围导出",notes="投票可见范围导出1")
//	@GetMapping("/vote")
//	public Response<String> exportVisibleRangeVote(HttpServletRequest request,
//			@ApiParam(name="voteId",value="投票ID", required = true) @RequestParam(name = "voteId", required = true) Long voteId) {
//		Map<String, Object> map = new HashMap<String, Object>();
//		map.put("voteId", voteId);
//		map.put("context", ContextHolder.get());
//		String result=(String)voteVisibleRangeExport.execute(map, false);
//		return Response.ok(result);
//	}

	@ApiOperation(value="直播可见范围导出",notes="直播可见范围导出1")
	@GetMapping("/live")
	public Response<String> exportVisibleRangeLive(HttpServletRequest request,
			@ApiParam(name="liveId",value="直播ID", required = true) @RequestParam(name = "liveId", required = true) Long liveId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("liveId", liveId);
		map.put("context", ContextHolder.get());
		String result=(String)liveVisibleRangeExport.execute(map, false);
		return Response.ok(result);
	}



	@ApiOperation(value="培训项目可见范围导出",notes="培训项目可见范围导出1")
	@GetMapping("/trainingProject")
	public Response<String> exportVisibleRangeTrainingProject(HttpServletRequest request,
			@ApiParam(name="trainingProjectId",value="培训项目ID", required = true) @RequestParam(name = "trainingProjectId", required = true) Long trainingProjectId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("trainingProjectId", trainingProjectId);
		map.put("context", ContextHolder.get());
		String result=(String)trainingProjectVisibleRangeExport.execute(map, false);
		return Response.ok(result);
	}

	@ApiOperation(value = "经验池学员范围导出", notes = "经验池学员范围导出")
	@GetMapping("/experiencePool")
	public Response<String> exportVisibleRangeExperiencePool(@ApiParam(value = "经验池ID", required = true) @RequestParam(name = "poolId", required = true) Long poolId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("poolId", poolId);
		map.put("context", ContextHolder.get());
		String result = (String) poolRangeExport.execute(map, false);
		return Response.ok(result);
	}

	@ApiOperation(value = "案例活动学员范围导出", notes = "案例活动学员范围导出")
	@GetMapping("/caseLibrary")
	public Response<String> caseLibraryRangeExperiencePool(@ApiParam(value = "案例活动ID", required = true) @RequestParam(name = "caseLibraryId", required = true) Long caseLibraryId) {
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("caseLibraryId", caseLibraryId);
		map.put("context", ContextHolder.get());
		String result = (String) caseLibraryRangeExport.execute(map, false);
		return Response.ok(result);
	}

}
