package com.yizhi.application.rangeImport;

import com.yizhi.assignment.application.feign.AssignmentClient;
import com.yizhi.assignment.application.vo.entity.AssignmentStudent;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.system.remote.AccountRangeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: dingxiaowei
 * @Date: 2018/9/17 16:44
 * @Description:作业可见范围异步导入
 */
@Component
public class AssignmentRangeImport extends AbstractDefaultTask<String, Map<String, Object>> {

    private static final Logger LOGGER = LoggerFactory.getLogger(AssignmentRangeImport.class);

    @Autowired
    private AccountRangeClient accountRangeClient;

    @Autowired
    private AssignmentClient assignmentClient;

    @Autowired
    private RangeUtil importUtil;

    @Override
    protected String execute(Map<String, Object> map) {
        //从map中取值
        String ossUrl = (String) map.get("ossUrl");
        RequestContext res = (RequestContext) map.get("requestContext");
        Long assignmentId = (Long) map.get("assignmentId");
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        Long accountId = res.getAccountId();
        String accountFullName = res.getAccountFullName();
        Long companyId = res.getCompanyId();
        Long siteId = res.getSiteId();
        Date submitTime = new Date();
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);
        //将请求值装入param
        AccountRangeImportParam param = new AccountRangeImportParam();
        param.setType(AccountRangeImportParam.Type.ASSIGNMENT);
        param.setOssUrl(ossUrl);
        param.setRequestContext(res);
        List<AccountRangeImportModel.SuccessAccount> successList = null;
        List<AccountRangeImportModel.ErrorAccount> errorList = null;
        List<Integer> integerList = null;
        //进行入库
        try {
            AccountRangeImportModel accountRangeImportModel = accountRangeClient.doImport(param);
            if (null != accountRangeImportModel) {
                successList = accountRangeImportModel.getSuccessList();
                errorList = accountRangeImportModel.getErrorList();
            }
            List<AssignmentStudent> assignmentStudents = new ArrayList<>();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Timestamp createTime = Timestamp.valueOf(sdf.format(new Date()));

            errorList = (errorList == null ? new ArrayList<>() : errorList);
            successList = (successList == null ? new ArrayList<>() : successList);


            AssignmentStudent assignmentStudent = null;
            if (!CollectionUtils.isEmpty(successList)) {
                for (AccountRangeImportModel.SuccessAccount rangeImportModel : successList) {
                    assignmentStudent = new AssignmentStudent();
                    assignmentStudent.setAssignmentId(assignmentId);
                    assignmentStudent.setType(2);
                    assignmentStudent.setAccountId(rangeImportModel.getId());
                    assignmentStudent.setCreateByName(accountFullName);
                    assignmentStudent.setCreateById(accountId);
                    assignmentStudent.setCreateTime(createTime);
                    assignmentStudents.add(assignmentStudent);
                }
                assignmentClient.insertStudentRelation(assignmentStudents);
            }
            importUtil.returnResults(taskContext, successList, errorList, ossUrl);

        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, "作业可见范围异步导入过程中出现错误:");
            LOGGER.error("作业可见范围异步导入过程中出现错误", e);
        }

        return "ok";
    }
}
