package com.yizhi.application.rangeImport;

import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.event.LogEvent;
import com.yizhi.core.application.log.LogEventPublisher;
import com.yizhi.core.application.log.TaskLogDetailEvent;
import com.yizhi.core.application.log.TaskLogEvent;
import com.yizhi.system.application.model.AccountRangeImportModel;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class RangeUtil {
    @Autowired
    LogEventPublisher publisher;

    public void returnResults(TaskContext taskContext,
                              List<AccountRangeImportModel.SuccessAccount> successList,
                              List<AccountRangeImportModel.ErrorAccount> errorList, String url) {

        System.out.println("开始返回");
        TaskLogEvent taskLogEvent = TaskLogEvent.success(taskContext, "成功导入" + successList.size() + "条," + "导入失败" + errorList.size() + "条", url);
        LogEvent<TaskLogEvent> event = new LogEvent("taskLog", taskLogEvent);
        this.publisher.publish(event);

        if (CollectionUtils.isNotEmpty(errorList)) {
            List<TaskLogDetailEvent> details = new ArrayList(errorList.size());
            Long taskId = taskContext.getTaskId();
            for (AccountRangeImportModel.ErrorAccount a : errorList) {
                details.add(new TaskLogDetailEvent(taskId, "第"+a.getLine()+"行,"+a.getErrMsg()));
            }
            LogEvent<List<TaskLogDetailEvent>> eventDetails = new LogEvent("batchTaskDetailLog", details);
            this.publisher.publish(eventDetails);

        }
    }
}
