package com.yizhi.application.report.course;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.course.application.feign.CourseReportClient;
import com.yizhi.course.application.vo.ReportStudyCourseAccountVo;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.baomidou.mybatisplus.plugins.Page;

/**
 * 按照用户统计导出Excel
 * @author wangfeida
 *
 */


@Component
public class CourseAccountGroupExportExcel extends AbstractDefaultTask<String, Map<String, Object>> {

	private static final Logger logger = LoggerFactory.getLogger(CourseAccountGroupExportExcel.class);

	@Autowired
	private CourseReportClient courseReportClient;

	@Override
	protected String execute(Map<String, Object> map) {
		// TODO Auto-generated method stub
		String upLoadUrl = null;
		Long accountId = (Long) map.get("accountId");
		Long companyId = (Long) map.get("companyId");
		Long orgId = (Long) map.get("orgId");
		Long siteId = (Long) map.get("siteId");
		String startDate = (String) map.get("startDate");
		String endDate = (String) map.get("endDate");
		String orgKwd = (String) map.get("orgKwd");
		String accountKwd = (String) map.get("accountKwd");
		Long taskId=(Long) map.get("taskId");
		Date submitTime=(Date) map.get("submitTime");
		String serialNo=(String) map.get("serialNo");
		String taskName=(String) map.get("taskName");
		Integer pageNo = 2;
		Integer pageSize = 30;
		
		/**
		 * 告诉任务，开始执行
		 */
		TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
		working(taskContext);
		
		
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMddHHmmss");
		
		Page<ReportStudyCourseAccountVo> page=new Page<ReportStudyCourseAccountVo>();
		page =courseReportClient.courseAccountGroupExport(accountKwd, orgKwd, startDate, endDate, companyId, orgId, siteId, pageNo-1, pageSize);
		List<ReportStudyCourseAccountVo> list = new ArrayList<ReportStudyCourseAccountVo>();
		
		if(page!=null) {
			logger.info("page记录{}",page.getTotal());
		}
		
		
		if(page!=null) {
			logger.info("查询到记录总数量{}",page.getTotal()/pageSize+1);
			list.addAll(page.getRecords());
			int num=page.getTotal()/pageSize+1;
			for (int  i= 2; i <= num; i++) {
				page = courseReportClient.courseAccountGroupExport(accountKwd, orgKwd, startDate, endDate, companyId, orgId, siteId, i, pageSize);
				if(page == null || page.getRecords().size() == 0) {
					break;
				}
				list.addAll(page.getRecords());
			}
		}
		try {
			// excel生成过程: excel-->sheet-->row-->cell
			// 第一步，创建一个Excel文件
			HSSFWorkbook wb = new HSSFWorkbook();
			// 最大限度是50000
			// 第二步，在webbook中添加一个sheet,对应Excel文件中的sheet
			HSSFSheet sheet = wb.createSheet("学员学习统计");
			// 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
			HSSFRow row = sheet.createRow((int) 0);
			// 第四步，创建单元格，并设置值表头 设置表头居中
			HSSFCellStyle style = wb.createCellStyle();
			style.setAlignment(HorizontalAlignment.CENTER); // 创建一个居中格式
			// 合并单元格
			CellRangeAddress cra = new CellRangeAddress(0, 0, 0, 10); // 起始行, 终止行, 起始列, 终止列
			sheet.addMergedRegion(cra);
			HSSFCell cell = row.createCell((short) 0);
			cell.setCellValue("学员学习统计");
			cell.setCellStyle(style);

			// 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
			HSSFRow row2 = sheet.createRow((int) 1);
			// 第四步，创建单元格
			CellRangeAddress cra2 = new CellRangeAddress(1, 1, 0, 3);
			sheet.addMergedRegion(cra2);
			HSSFCell cell2 = row2.createCell((short) 0);
			cell2.setCellValue("统计周期： " + startDate + "~" + endDate);

			HSSFRow row3 = sheet.createRow((int) 2);
			row3.createCell((short) 0).setCellValue("用户名");
			row3.createCell((short) 1).setCellValue("姓名");
			row3.createCell((short) 2).setCellValue("工号");
			row3.createCell((short) 3).setCellValue("可学课程数");
			row3.createCell((short) 4).setCellValue("参加课程数");
			row3.createCell((short) 5).setCellValue("完成课程数");
			row3.createCell((short) 6).setCellValue("未完成课程数");
			row3.createCell((short) 7).setCellValue("总学习时长(分钟)");
			row3.createCell((short) 8).setCellValue("最后学习时间");
			row3.createCell((short) 9).setCellValue("用户当前状态");
			row3.createCell((short) 10).setCellValue("所在部门");

			// 第五步，写入实体数据 实际应用中这些数据从数据库得到，
			if(!CollectionUtils.isEmpty(list)) {
			for (int i = 0; i < list.size(); i++) {
				row = sheet.createRow(i + 3); 
				ReportStudyCourseAccountVo rscav = list.get(i);
				if(rscav!=null) {
					// 第四步，创建单元格，并设置值
					row.createCell((short) 0).setCellValue(rscav.getAccountName());
					row.createCell((short) 1).setCellValue(rscav.getAccountFullName());
					row.createCell((short) 2).setCellValue(rscav.getWorkNum());
					row.createCell((short) 3).setCellValue(rscav.getTotalAskCourse());
					row.createCell((short) 4).setCellValue(rscav.getTotalInCourse());
					row.createCell((short) 5).setCellValue(rscav.getTotalFinishCourse());
					row.createCell((short) 6).setCellValue(rscav.getTotalNoFinishCourse());
					if(rscav.getTotalDuration() == null){
						row.createCell((short) 7).setCellValue("0.0");
					}else {
						row.createCell((short) 7).setCellValue(rscav.getTotalDuration().toString());
					}
					if(rscav.getLastTime()!=null) {
						row.createCell((short) 8).setCellValue(df.format(rscav.getLastTime()));
					}
					row.createCell((short) 9).setCellValue(rscav.getAccountState()==1?"启用":"禁用");
					row.createCell((short) 10).setCellValue(rscav.getOrgName());
					//taskDetail(taskContext.getTaskId(), "按用户统计-下载学习统计数据+" + i + "+行成功");
				}
				
			}
			}
			String fileName = "按用户统计-下载学习统计数据" + df2.format(submitTime) + ".xls";
			//String requestPath = "E:\\home";
			String requestPath = FileConstant.SAVE_PATH;
			File fileDir = new File(requestPath);
			if (!fileDir.exists()) {
				fileDir.mkdir();
			}
			String path = requestPath + fileName;
			FileOutputStream os = null;
			File file = null;
			try {
				os = new FileOutputStream(path);
				wb.write(os);
				// 阿里云返回url
				upLoadUrl = OssUpload.upload(path, fileName);
				file = new File(path);
				success(taskContext, "成功", upLoadUrl);
			} catch (Exception e1) {
				e1.printStackTrace();
				fail(taskContext, "写入过程中发生错误");
				logger.error("上传过程中发生错误，请查看日志");
			} finally {
				if (os != null) {
					os.close();
				}
				if (wb != null) {
					wb.close();
				}
				if (file != null) {
					file.delete();
				}
			}

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			fail(taskContext, "按用户统计-下载学习统计数据导出过程中发生错误，请查看日志");
			logger.error("按用户统计-下载学习统计数据导出过程中发生错误，请查看日志");
		}
		return upLoadUrl;
	}
}
