
package com.yizhi.application.report.course;

import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.course.application.feign.CourseReportClient;
import com.yizhi.course.application.vo.ReportStudyCourseOrgVo;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.baomidou.mybatisplus.plugins.Page;
/**
 * 按照部门统计导出Excel
 * @author wangfeida
 *
 */



@Component
public class CourseOrgGroupExportExcel extends AbstractDefaultTask<String, Map<String, Object>> {

	private static final Logger logger = LoggerFactory.getLogger(CourseOrgGroupExportExcel.class);

	@Autowired
	private CourseReportClient courseReportClient;

	@Override
	protected String execute(Map<String, Object> map) {
		// TODO Auto-generated method stub
		String upLoadUrl = null;
		Long accountId = (Long) map.get("accountId");
		Long companyId = (Long) map.get("companyId");
		Long orgId = (Long) map.get("orgId");
		Long siteId = (Long) map.get("siteId");
		String startDate = (String) map.get("startDate");
		String endDate = (String) map.get("endDate");
		String kwd = (String) map.get("kwd");
		Long taskId=(Long) map.get("taskId");
		Date submitTime=(Date) map.get("submitTime");
		String serialNo=(String) map.get("serialNo");
		String taskName=(String) map.get("taskName");
		
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
		working(taskContext);
		
		
		Integer pageNo = 2;
		Integer pageSize = 30;
		List<ReportStudyCourseOrgVo> list=new ArrayList<ReportStudyCourseOrgVo>();
		Page<ReportStudyCourseOrgVo> page = new Page<ReportStudyCourseOrgVo>();
		page = courseReportClient.courseOrgGroup(kwd, startDate, endDate, companyId, orgId, siteId, pageNo-1, pageSize);
		if(page!=null) {
			list.addAll(page.getRecords());
			int num=page.getTotal()/pageSize+1;
			for (int  i= 2; i <= num; i++) {
				page = courseReportClient.courseOrgGroup(kwd, startDate, endDate, companyId, orgId, siteId, i, pageSize);
				if(page == null || page.getRecords().size() == 0) {
					break;
				}
				list.addAll(page.getRecords());
			}
		}
		
		SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMddHHmmss");
		
		
		try {
			// excel生成过程: excel-->sheet-->row-->cell
			// 第一步，创建一个Excel文件
			HSSFWorkbook wb = new HSSFWorkbook();
			// 最大限度是50000
			// 第二步，在webbook中添加一个sheet,对应Excel文件中的sheet
			HSSFSheet sheet = wb.createSheet("部门学习情况统计");
			// 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
			HSSFRow row = sheet.createRow((int) 0);
			// 第四步，创建单元格，并设置值表头 设置表头居中
			HSSFCellStyle style = wb.createCellStyle();
			style.setAlignment(HorizontalAlignment.CENTER); // 创建一个居中格式
			// 合并单元格
			CellRangeAddress cra = new CellRangeAddress(0, 0, 0, 7); // 起始行, 终止行, 起始列, 终止列
			sheet.addMergedRegion(cra);
			HSSFCell cell = row.createCell((short) 0);
			cell.setCellValue("部门学习情况统计");
			cell.setCellStyle(style);

			// 第三步，在sheet中添加表头第0行,注意老版本poi对Excel的行数列数有限制short
			HSSFRow row2 = sheet.createRow((int) 1);
			// 第四步，创建单元格
			CellRangeAddress cra2 = new CellRangeAddress(1, 1, 0, 3);
			sheet.addMergedRegion(cra2);
			HSSFCell cell2 = row2.createCell((short) 0);
			cell2.setCellValue("统计周期： " + startDate + "~" + endDate);

			HSSFRow row3 = sheet.createRow((int) 2);
			row3.createCell((short) 0).setCellValue("部门编码");
			row3.createCell((short) 1).setCellValue("部门名称");
			row3.createCell((short) 2).setCellValue("参加课程数");
			row3.createCell((short) 3).setCellValue("参加人数");
			row3.createCell((short) 4).setCellValue("总学习次数");
			row3.createCell((short) 5).setCellValue("总学习时长(分钟)");
			row3.createCell((short) 6).setCellValue("平均学习时长(分钟)");
			// 第五步，写入实体数据 实际应用中这些数据从数据库得到，
			BigDecimal b;
			BigDecimal big;
			if(list!=null&&list.size()>0) {
			for (int i = 0; i < list.size(); i++) {
				row = sheet.createRow(i + 3);
				ReportStudyCourseOrgVo rscv = new ReportStudyCourseOrgVo();
				rscv = list.get(i);
				// 第四步，创建单元格，并设置值
				if(rscv!=null) {
					row.createCell((short) 0).setCellValue(rscv.getOrgNo());
					row.createCell((short) 1).setCellValue(rscv.getOrgName());
					row.createCell((short) 2).setCellValue(rscv.getTotalInCourse());
					row.createCell((short) 3).setCellValue(rscv.getTotalInAccount());
					row.createCell((short) 4).setCellValue(rscv.getTotalCount());
					row.createCell((short) 5).setCellValue(rscv.getTotalDuration());
					if(rscv.getTotalDuration() == null){
						row.createCell((short) 6).setCellValue("0.0");
					}else if (rscv.getTotalCount() != 0){
						b=new BigDecimal(Double.valueOf(rscv.getTotalDuration()));
						big = new BigDecimal(rscv.getTotalCount());
						row.createCell((short) 6).setCellValue(b.divide(big,1,BigDecimal.ROUND_HALF_UP).toString());
					}else {
						row.createCell((short) 6).setCellValue(rscv.getTotalDuration());
					}


					
					//taskDetail(taskContext.getTaskId(), "部门学习情况统计导出数据第+" + (i+1) + "+行成功");
				}
				
			}
			}
			String fileName = "部门学习情况统计" + df2.format(submitTime) + ".xls";
			//String requestPath = "E:\\home";
			String requestPath = FileConstant.SAVE_PATH;
			File fileDir = new File(requestPath);
			if (!fileDir.exists()) {
				fileDir.mkdir();
			}
			String path = requestPath + fileName;
			FileOutputStream os = null;
			File file = null;
			try {
				os = new FileOutputStream(path);
				wb.write(os);
				// 阿里云返回url
				upLoadUrl = OssUpload.upload(path, fileName);
				file = new File(path);
				success(taskContext, "成功", upLoadUrl);
			} catch (Exception e1) {
				e1.printStackTrace();
				fail(taskContext, "写入过程中发生错误");
				logger.error("上传过程中发生错误，请查看日志");
			} finally {
				if (os != null) {
					os.close();
				}
				if (wb != null) {
					wb.close();
				}
				if (file != null) {
					file.delete();
				}
			}

		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			fail(taskContext, "部门学习情况统计导出过程中发生错误，请查看日志");
			logger.error("部门学习情况统计导出过程中发生错误，请查看日志");
		}
		return upLoadUrl;
	}
}
