package com.yizhi.application.report.research;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.research.application.vo.report.ResearchGroupVo;
import com.yizhi.statistics.application.feign.StatisticsResearchReportClient;
import com.yizhi.statistics.application.vo.research.ResearchGroupViewVo;
import com.yizhi.system.application.system.remote.ReportClient;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 调研报表统计
 *
 * @author mei
 */

@Api (tags = "报表统计-调研", description = "报表统计-调研")
@RestController
@RequestMapping ("/manage/report/research/")
public class ReportResearch2 {

    private static final Logger LOGGER = LoggerFactory.getLogger(ReportResearch2.class);

    private SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm");


    @Autowired
    private StatisticsResearchReportClient statisticsResearchClient;
    @Autowired
    private ReportClient reportClient;

    @ApiOperation (value = "调研统计", notes = "调研统计", response = ResearchGroupVo.class)
    @GetMapping ("/group")
    public Response<ResearchGroupVo> researchGroup(
            @ApiParam (value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam (name = "startDate", required = false) String startDate,
            @ApiParam (value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam (name = "endDate", required = false) String endDate,
            @ApiParam (value = "调研关键字", required = false) @RequestParam (name = "kwd", required = false) String kwd,
            @ApiParam (value = "每页条数，默认10", required = false) @RequestParam (name = "pageSize", required = false, defaultValue = "10") Integer pageSize,
            @ApiParam (value = "当前页数", required = false) @RequestParam (name = "pageNo", required = false, defaultValue = "1") Integer pageNo) {
        if (startDate == "") {
            startDate = null;
        }
        if (endDate == "") {
            endDate = null;
        }
        if (kwd != null) {
            kwd = kwd.replace(" ", "");
        }
        if (kwd == "") {
            kwd = null;
        }
        Map<String, Integer> pageMap = new HashMap<String, Integer>();
        Page<com.yizhi.statistics.application.vo.research.ResearchGroupVo> page;
        List<com.yizhi.statistics.application.vo.research.ResearchGroupVo> list;
        try {
            RequestContext context = ContextHolder.get();
            Long companyId = context.getCompanyId();
            List<Long> orgIds = context.getOrgIds();
            Long siteId = context.getSiteId();
            page = statisticsResearchClient.researchGroup(startDate, endDate, kwd, pageSize, pageNo, companyId, orgIds, siteId);
            list = page.getRecords();
            pageMap.put("pageNo", pageNo);
            pageMap.put("pageSize", pageSize);
            pageMap.put("pageTotal", page.getTotal());
            return Response.ok(list, pageMap);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

    }

    @ApiOperation (value = "调研统计-查看", notes = "调研统计-查看", response = ResearchGroupViewVo.class)
    @GetMapping ("/group/view")
    public Response<ResearchGroupViewVo> researchGroupView(
            @ApiParam (value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam (name = "startDate", required = false) String startDate,
            @ApiParam (value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam (name = "endDate", required = false) String endDate,
            @ApiParam (value = "是否参加", required = false) @RequestParam (name = "state", required = false) Integer state,
            @ApiParam (value = "调研id", required = true) @RequestParam (name = "researchId", required = true) Long researchId,
            @ApiParam (value = "部门关键字或者部门编码", required = false) @RequestParam (name = "orgNameorOrgCode", required = false) String orgNameorOrgCode,
            @ApiParam (value = "用户关键字", required = false) @RequestParam (name = "accountName", required = false) String accountName,
            @ApiParam (value = "当前页", required = false) @RequestParam (name = "pageNo", required = true, defaultValue = "1") Integer pageNo,
            @ApiParam (value = "每页的个数", required = false) @RequestParam (name = "pageSize", required = true, defaultValue = "10") Integer pageSize) {
        if (startDate == "") {
            startDate = null;
        }
        if (endDate == "") {
            endDate = null;
        }
        if (orgNameorOrgCode != null) {
            orgNameorOrgCode = orgNameorOrgCode.replace(" ", "");
        }
        if (orgNameorOrgCode == "") {
            orgNameorOrgCode = null;
        }
        if (accountName != null) {
            accountName = accountName.replace(" ", "");
        }
        if (accountName == "") {
            accountName = null;
        }
        Map<String, Integer> pageMap = new HashMap<String, Integer>();
        pageMap.put("pageNo", pageNo);
        pageMap.put("pageSize", pageSize);
        try {
            RequestContext context = ContextHolder.get();
            Page<ResearchGroupViewVo> page = statisticsResearchClient.researchGroupView(startDate, endDate, researchId, orgNameorOrgCode, accountName, state, pageSize, pageNo);
            List<ResearchGroupViewVo> list = page.getRecords();
            pageMap.put("pageTotal", page.getTotal());
            return Response.ok(list, pageMap);
        } catch (Exception e) {
            LOGGER.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @GetMapping ("/asynchronous/load/data")
    public Response<String> intoCourseReport(@ApiParam (value = "开始时间（yyyy-mm-dd）", required = false) @RequestParam (name = "startDate", required = false) String startDate,
                                             @ApiParam (value = "结束时间（yyyy-mm-dd）", required = false) @RequestParam (name = "endDate", required = false) String endDate) {
        statisticsResearchClient.asynchronousResearch(startDate, endDate);
        return Response.ok("ok");
    }
}
