package com.yizhi.application.util;

import com.yizhi.core.application.publish.PublicSendMessageClient;
import com.yizhi.core.application.vo.MessageRemindVo;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.core.application.publish.CloudEventPublisher;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.message.application.constans.Constans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskSendMessage {

    @Autowired
    private PublicSendMessageClient publicSendMessageClient;
    @Autowired
    private TaskExecutor taskExecutor;
    private Logger logger = LoggerFactory.getLogger(TaskSendMessage.class);


    /**
     * 业务上下架发消息
     *
     * @param relationType 业务类型
     * @param taskId       业务id
     * @param taskStatus   业务状态
     */
    public void taskUpOrDown(Integer relationType, Long taskId, Integer taskStatus, RequestContext requestContext) {
        if (relationType == null || taskId == null || taskStatus == null) {
            logger.info("缺少必要参数");
            return;
        }
        MessageRemindVo vo = new MessageRemindVo();


        vo.setRelationId(taskId);
        vo.setRelationType(relationType);
        vo.setTaskStatus(getStatus(relationType, taskStatus));
        vo.setRequestContext(requestContext);

        try {
            taskExecutor.asynExecute(new AbstractTaskHandler() {
                @Override
                public void handle() {
                    publicSendMessageClient.processBizEvent(vo);
                }
            });
            if (taskStatus == 1) {
                logger.info("发送上架消息成功=====================");
            } else {
                logger.info("发送下架消息成功=====================");
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("发送上下架消息失败=====================", e);
        }

    }

    /**
     * 获取业务的状态转化成消息需要的类型
     *
     * @param relationType
     * @param status
     * @return
     */
    private Integer getStatus(Integer relationType, Integer status) {
        logger.info("relationType" + relationType + "||status" + status);

        switch (relationType) {
            // "关联模块类型(、1：学习计划、2：考试、3：调研、4、投票5：报名、6：作业、7：签到、8：项目、9：直播、10：积分、11课程)"
            case 1:
                if (status == 1) {
                    return 1;
                } else {
                    return 0;
                }
            case 2:
                if (status == 2) {
                    return 1;
                } else {
                    return 0;
                }
            case 3:
                if (status == 1) {
                    return 1;
                } else {
                    return 0;
                }
            case 4:
                break;
            case 5:
                break;
            case 6:
                if (status == 3) {
                    return 1;
                } else {
                    return 0;
                }
            case 7:
                getStatus(1, status);
            case 8:
                getStatus(1, status);
            case 9:
                if (status == 1) {
                    return 1;
                } else {
                    return 0;
                }
            case 10:
                break;
            case 11:
                break;
        }
        return -1;
    }


}
