package com.yizhi.application.course.utils;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.course.application.vo.ApiCommnentVo;
import com.yizhi.course.application.vo.domain.ReplyEntityVo;
import com.yizhi.system.application.system.remote.AccountClient;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.util.application.json.JsonUtil;
import com.yizhi.util.application.sensitive.SensitivewordFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

@Component
public class StuWorkUtil {
    @Autowired
    private AccountClient accountClient;
    @Autowired
    private RedisCache redisCache;


    public Page fillData(Page page, RequestContext context) {
        if (null != page) {
            List<ApiCommnentVo> commentVos = page.getRecords();
            //取得用户id集合，只查一次库
            Set<Long> accountIds = new HashSet<>();
            List<Long> listSet = new ArrayList<>();
            if (!CollectionUtils.isEmpty(commentVos)) {
                commentVos.forEach(commentVo1 -> {
                    //评论者id
                    accountIds.add(commentVo1.getAccountId());
                    List<ReplyEntityVo> replyVos = commentVo1.getReplies();
                    if (!CollectionUtils.isEmpty(replyVos)) {
                        replyVos.forEach(replyVo -> {
                            //回复者Id
                            accountIds.add(replyVo.getAccountId());
                        });
                    }
                });
                //去重
                listSet.addAll(accountIds);
                List<AccountVO> accountVOs = accountClient.idsGet(listSet);

                Map<Long, String> nameMap = new HashMap<>();
                Map<Long, String> headPhotoMap = new HashMap<>();
                //组装map
                getMap(nameMap, headPhotoMap, accountVOs);

                Long companyId = context.getCompanyId();
                Set<String> sensitiveWordList = new HashSet<>();
                String sensitiveValues = (String) redisCache.hget(CacheNamespace.REDIS_SENSITIVE_WORD_INFO, companyId.toString());
                if (sensitiveValues != null) {
                    sensitiveWordList = JsonUtil.json2Ojbect(sensitiveValues, Set.class);
                }

                //如果用户有真实名字则用，无则采用账户名
                for (ApiCommnentVo commentVo2 : commentVos) {
                    commentVo2.setCommentator(nameMap.get(commentVo2.getAccountId()));
                    commentVo2.setUserAvatar(headPhotoMap.get(commentVo2.getAccountId()));
                    //过滤敏感词
                    String afterFilter = filterWord(commentVo2.getContent(), sensitiveWordList);
                    commentVo2.setContent(afterFilter);
                    List<ReplyEntityVo> replyVos = commentVo2.getReplies();
                    //组装reply
                    fillReply(replyVos, nameMap, sensitiveWordList);
                }
            }
        }
        return page;
    }

    /**
     * 组装map
     * @param nameMap  名字map
     * @param headPhotoMap  头像map
     * @param accountVOs  已评论或已回复人的id集合
     */
    public void getMap(Map<Long, String> nameMap, Map<Long, String> headPhotoMap, List<AccountVO> accountVOs) {
        accountVOs.forEach(accountVo -> {
            String name = ((accountVo.getFullName() == "" ? null : accountVo.getFullName()) == null ? accountVo.getName() : accountVo.getFullName());

            if (!nameMap.containsKey(accountVo.getId())) {
                nameMap.put(accountVo.getId(), name);
            }
            if (!headPhotoMap.containsKey(accountVo.getId())) {
                headPhotoMap.put(accountVo.getId(), accountVo.getHeadPortrait());
            }
        });

    }

    /**
     * 组装reply
     * @param replyVos   回复列表
     * @param nameMap     《accountId,accountName》名字map
     * @param sensitiveWordList  管理端已设置的敏感词集合
     */
    public void fillReply(List<ReplyEntityVo> replyVos, Map<Long, String> nameMap, Set<String> sensitiveWordList) {
        if (!CollectionUtils.isEmpty(replyVos)) {
            for (ReplyEntityVo replyVo : replyVos) {
                replyVo.setReplier(nameMap.get(replyVo.getAccountId()));
                replyVo.setParentAccountName(nameMap.get(replyVo.getParentAccountId()));
                //过滤敏感词
                String afterFilter = filterWord(replyVo.getContent(), sensitiveWordList);
                replyVo.setContent(afterFilter);
            }
        }

    }

    /**
     * 过滤敏感词
     * @param content  评论内容
     * @param sensitiveWordList  已设置的敏感词集合
     * @return
     */
    public String filterWord(String content, Set<String> sensitiveWordList) {
        if (sensitiveWordList != null) {
            if (!StringUtils.isBlank(content)) {
                return SensitivewordFilter.sensitiveFilter(content, sensitiveWordList);
            }
        }
        return content;
    }

    /**
     * 组装reply   这个组装是需要组装头像的
     * @param replyVos   回复列表
     * @param nameMap     《accountId,accountName》名字map
     * @param sensitiveWordList  管理端已设置的敏感词集合
     */
    public void fillReply2(List<ReplyEntityVo> replyVos, Map<Long, String> nameMap,Map<Long, String> headPhotoMap, Set<String> sensitiveWordList) {
        if (!CollectionUtils.isEmpty(replyVos)) {
            for (ReplyEntityVo replyVo : replyVos) {
                replyVo.setReplier(nameMap.get(replyVo.getAccountId()));
                replyVo.setParentAccountName(nameMap.get(replyVo.getParentAccountId()));
                //过滤敏感词
                String afterFilter = filterWord(replyVo.getContent(), sensitiveWordList);
                replyVo.setContent(afterFilter);
                replyVo.setUserAvatar(headPhotoMap.get(replyVo.getAccountId()));
            }
        }

    }

}
