package com.yizhi.application.inform;



import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.accountUtil.QueryAccountUtil;
import com.yizhi.comment.application.constans.Constant;
import com.yizhi.comment.application.feign.InformRecordClient;
import com.yizhi.comment.application.vo.InformCommentVo;
import com.yizhi.comment.application.vo.InformRecordVo;
import com.yizhi.forum.application.feign.PostsForbiddenAccountClient;
import com.yizhi.forum.application.vo.domain.PostsForbiddenAccountVo;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Api(tags = "学员端-举报接口")
@RestController
@RequestMapping("/student/inform")
public class StudentInformController {

    private static final Logger LOG = LoggerFactory.getLogger(StudentInformController.class);


    @Autowired
    private InformRecordClient informRecordClient;
    @Autowired
    private PostsForbiddenAccountClient postsForbiddenAccountClient;
    @Autowired
    private QueryAccountUtil queryAccountUtil;

    @PostMapping("/save")
    @ApiOperation(value = "插入举报记录")
    public Response<Object> save(@ApiParam("vo") @RequestBody InformRecordVo vo) {
        if (vo.getType() == null) {
            return Response.fail("type必传");
        }
        informRecordClient.save(vo);
        return Response.ok("操作成功！");
    }

    @GetMapping("/getPage")
    @ApiOperation(value = "获取举报记录列表 ")
    public Response<Object> getPage(@ApiParam("业务类型 2-评论回复") @RequestParam("taskType") Integer taskType,
                                    @ApiParam("业务id taskType=2时，为帖子id ") @RequestParam("taskId") Long taskId,
                                    @ApiParam("type  0-帖子 1-评论") @RequestParam(value = "type") Integer type,
                                    @ApiParam("终端类型：1-管理端   2-pc端   3-微信端  4-app") @RequestParam("terminalType") Integer terminalType,
                                    @ApiParam("页码") @RequestParam("pageNo") Integer pageNo,
                                    @ApiParam("页面条数") @RequestParam("pageSize") Integer pageSize) {

        Page<InformRecordVo> page = informRecordClient.getPage(taskType, taskId, type, terminalType, pageNo, pageSize);
        List<InformRecordVo> records = page.getRecords();
        if (!CollectionUtils.isEmpty(records)) {

            List<Long> accountIds = new ArrayList<>(records.size());
            if (Constant.TASK_TYPE_COMMENT_REPLY.equals(type)) {
                //获取禁言名单
                Page<PostsForbiddenAccountVo> page1 = postsForbiddenAccountClient.getPage(taskId, 1, Integer.MAX_VALUE);
                List<PostsForbiddenAccountVo> forbiddenAccounts = page1.getRecords();
                List<Long> forbiddenAccountIds = forbiddenAccounts.stream().map(a -> a.getAccountId()).collect(Collectors.toList());

                //实时获取用户名
                records.forEach(a -> {
                    accountIds.add(a.getCreateById());
                    if (a.getInformCommentVo() != null) {
                        accountIds.add(a.getInformCommentVo().getAccountId());
                    }
                });
                Map<Long, AccountVO> accountMap = queryAccountUtil.queryAccountByIds(accountIds);
                records.forEach(a -> {
                    if (accountMap != null) {
                        AccountVO accountVO1 = accountMap.get(a.getCreateById());
                        if (accountVO1 != null) {
                            a.setUserAvatar(accountVO1.getHeadPortrait());
                        }
                        InformCommentVo commentVo = a.getInformCommentVo();
                        if (commentVo != null) {
                            AccountVO accountVO = accountMap.get(commentVo.getAccountId());
                            if (accountVO != null) {
                                commentVo.setCommentator(accountVO.getName());
                                commentVo.setUserAvatar(accountVO.getHeadPortrait());
                            }
                        }
                        commentVo.setHasForbidden(forbiddenAccountIds.contains(commentVo.getAccountId()));
                    }
                });
            }
        }
        return Response.ok(page);
    }

}

