package com.yizhi.application.protal.controller;

import com.alibaba.fastjson.JSON;
import com.yizhi.site.application.feign.SiteManageFeignClients;
import com.yizhi.site.application.vo.domain.AppVersionVo;
import com.yizhi.site.application.vo.site.SiteConfigVO;
import com.yizhi.site.application.vo.site.SystemSiteVO;
import com.yizhi.system.application.system.remote.CompanyClient;
import com.yizhi.system.application.system.remote.SiteClient;
import com.yizhi.system.application.vo.CompanyVO;
import com.yizhi.system.application.vo.SiteVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lingye
 * pc 配置 名字和图标
 *
 */

@Api(tags = "网页名称和图标")
@RestController
@RequestMapping("/api/site/config")
public class SiteConfigController {

    private static final Logger LOG = LoggerFactory.getLogger(SiteConfigController.class);

    @Autowired
    SiteManageFeignClients siteManageFeignClients;

    @Autowired
    SiteClient siteClient;

    @Autowired
    CompanyClient companyClient;


    /**
     * 获取网站的信息
     * @return
     */
    @GetMapping("/public/get")
    public Response<SiteConfigVO> get(@RequestParam(name = "siteCode") String siteCode, @RequestParam(name = "companyCode") String companyCode) {


        CompanyVO companyVO = companyClient.findByCode(companyCode);

        if (companyVO!=null) {
            SiteVO siteVO = siteClient.findByName(siteCode, companyVO.getId());
            LOG.info("站点findByName查询结果={}", JSON.toJSONString(siteVO));
            if(siteVO == null){
                return Response.fail("站点信息不存在");
            }
            SystemSiteVO systemSiteVO = new SystemSiteVO();
            BeanUtils.copyProperties(siteVO,systemSiteVO);
            return Response.ok(siteManageFeignClients.get(systemSiteVO));
        } else {
            return Response.ok();
        }
    }

    @GetMapping("/public/appVersion")
    public Response<AppVersionVo> getAppVersion(@RequestParam(name = "siteCode") String siteCode,
                                                @RequestParam(name = "companyCode") String companyCode,
                                                @RequestParam(name = "type") Integer type){
       try {
            AppVersionVo appVersion = siteManageFeignClients.getAppVersion(siteCode,companyCode,type);
            return Response.ok(appVersion);
        } catch (Exception e) {
            return Response.fail(e.getMessage());
        }


    }

}
