package com.yizhi.application.rankList.controller;

import com.yizhi.core.application.token.TokenHelper;
import com.yizhi.course.application.feign.RankListClient;
import com.yizhi.course.application.vo.AccountDurationVO;
import com.yizhi.course.application.vo.TokenParamVO;
import com.yizhi.util.application.constant.GlobalConstant;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import io.jsonwebtoken.Claims;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api(tags = "申万宏源-风云榜")
@RestController
@RequestMapping("/api/course/rank")
public class UserRankListController {
	
	private static final Logger logger = LoggerFactory.getLogger(UserRankListController.class);

	@Autowired
	private RankListClient rankListClient;
	
	@Autowired
	private TokenHelper tokenHelper;
	
	@PostMapping("/list")
    @ApiOperation(value = "申万宏源风云榜",response = AccountDurationVO.class)
	public Response<Object> getUserRank(@RequestBody TokenParamVO tokenParamVO) {
		logger.info("进入用户学时风云榜接口");
		String token = tokenParamVO.getToken();
		logger.info("令牌信息=token{}", token);
		if (StringUtils.isEmpty(token)) {
			logger.info("令牌信息为空，请重新登陆获取令牌信息");
			return Response.fail(ReturnCode.NO_TOKEN.getCode(), ReturnCode.NO_TOKEN.getMsg());
		}
		Claims claims = tokenHelper.parseToken(token);
		if (claims == null) {
			logger.info("解析令牌为空，令牌失效或者过期，请重新登陆");
			return Response.fail(ReturnCode.TOKEN_INVALID.getCode(), ReturnCode.TOKEN_INVALID.getMsg());
		}
		Long accountId = Long.valueOf(claims.get(GlobalConstant.ACCOUNT_ID, String.class));
		Long companyId = Long.valueOf(claims.get(GlobalConstant.COMPANY_ID, String.class));
		Long siteId = Long.valueOf(claims.get(GlobalConstant.SITE_ID, String.class));
		AccountDurationVO accountDurationVO =null;
        try {
        	accountDurationVO = rankListClient.userRank(accountId, companyId, siteId, tokenParamVO.getTop());
        } catch (Exception e) {
        	logger.info("课程服务异常："+e);
            return Response.fail(Constants.COURSE_MSG_BIZ_ERROR);
        }
		logger.info("返回用户学时风云榜");
        return Response.ok(accountDurationVO);
	}
}
