package com.yizhi.application.course.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.assignment.application.vo.entity.Comment;
import com.yizhi.course.application.feign.CommClient;
import com.yizhi.course.application.feign.CommentClient;
import com.yizhi.course.application.vo.PageCommentVo;
import com.yizhi.course.application.vo.domain.CommentEntityVo;
import com.yizhi.course.application.vo.domain.ReplyEntityVo;
import com.yizhi.util.application.domain.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 评论 前端控制器
 * 
 * @author Fairyland
 *
 */

@Api(tags = "管理端-课程评论", description = "评论接口")
@RestController
@RequestMapping("/manage/comment")
public class CommentController {
	private static final Logger logger = LoggerFactory.getLogger(CommentController.class);

	@Autowired
	CommClient commClient;

	@Autowired
	CommentClient commentClient;

	@ApiOperation(value = "根据课程id获取评论列表(分页查询)", response = PageCommentVo.class)
	@GetMapping("/list")
	public Response getCommentList(
			@ApiParam(name = "courseId", value = "课程id") @RequestParam(name = "courseId") Long courseId,
			@ApiParam(name = "courseName", value = "课程名称") @RequestParam(name = "courseName") String courseName,
			@RequestParam(name = "commentator", required = false) String commentator,
			@RequestParam(name = "status", required = false) Integer status,
			@ApiParam(name = "pageNo", value = "跳转页数,默认第一页") @RequestParam(name = "pageNo", defaultValue = "1", required = false) Integer pageNo,
			@ApiParam(name = "pageSize", value = "每页条数,默认20条") @RequestParam(name = "pageSize", defaultValue = "10", required = false) Integer pageSize) {
		PageCommentVo pageCommentVo = commClient.list(courseId, commentator, status, pageNo, pageSize);
		pageCommentVo.setCourseName(courseName);
		return Response.ok(pageCommentVo);
	}

	@ApiOperation(value = "根据课程id获取评论列表(分页查询)", response = ReplyEntityVo.class)
	@GetMapping("/reply/list")
	public Response getCommentList(
			@ApiParam(name = "commmentId", value = "课程id") @RequestParam(name = "commmentId") Long commmentId,
			@ApiParam(name = "pageNo", value = "跳转页数,默认第一页") @RequestParam(name = "pageNo", defaultValue = "1", required = false) Integer pageNo,
			@ApiParam(name = "pageSize", value = "每页条数,默认20条") @RequestParam(name = "pageSize", defaultValue = "10", required = false) Integer pageSize) {
		Page<ReplyEntityVo> page = commClient.replyList(commmentId, pageNo, pageSize);
		return Response.ok(page);
	}

	@ApiOperation(value = "根据Comment评论id审核该评论，审核确定后 评论会从列表消失 连评论下的回复一起消失")
	@PostMapping("/auditComment")
	public Response<String> auditComment(@ApiParam(name = "comment", value = "评论") @RequestBody CommentEntityVo comment) {
		String result = commentClient.auditComment(comment);
		if (!StringUtils.isEmpty(result)) {
			if ("success".equals(result)) {
				return Response.ok();
			} else {
				return Response.fail();
			}
		}
		return Response.fail();
	}

	@ApiOperation(value = "根据reply回复评论id审核该评论，审核确定后 评论会从列表消失")
	@PostMapping("/auditReply")
	public Response<String> auditreply(@ApiParam(name = "id", value = "评论id") @RequestBody ReplyEntityVo reply

	) {
		String result = commentClient.auditreply(reply);
		if (!StringUtils.isEmpty(result)) {
			if ("success".equals(result)) {
				return Response.ok();
			} else {
				return Response.fail();
			}
		}
		return Response.fail();
	}

//	@ApiOperation(value="点赞")
//	@PostMapping("thumbsUp/save")
//	public Response<String> saveThumbsUp(
//			@RequestBody ThumbsUp thumbsUp
//	){
//		Boolean f = commClient.saveThumbsUp(thumbsUp);
//		if (f) {
//			return Response.ok();
//		}else {
//			return Response.fail();
//		}
//
//	}

	@ApiOperation(value = "上架")
	@GetMapping("/up")
	public Response<String> up(@RequestParam("id") Long id, @RequestParam("type") Integer type) {
		Boolean up = commClient.up(id, type);
		if (up) {
			return Response.ok();
		} else {
			return Response.fail();
		}
	}

	@ApiOperation(value = "下架")
	@GetMapping("/down")
	public Response<String> down(@RequestParam("id") Long id, @RequestParam("type") Integer type) {
		Boolean up = commClient.down(id, type);
		if (up) {
			return Response.ok();
		} else {
			return Response.fail();
		}
	}

	@ApiOperation(value = "评论信息导出")
	@GetMapping("/list/export")
	public Response<String> export(
			@ApiParam(name = "courseId", value = "课程id") @RequestParam(name = "courseId") Long courseId,
			@ApiParam(name = "courseName", value = "课程名称") @RequestParam(name = "courseName") String courseName,
			@RequestParam(name = "commentator", required = false) String commentator,
			@RequestParam(name = "status", required = false) Integer status) {
		return Response.ok(commClient.export(courseId, courseName, commentator, status).get("result").toString());
	}
}
